/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.ExecSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

public final class ExecUtils {
    private final boolean trace;

    public ExecUtils(boolean trace) {
        this.trace = trace;
    }

    public int exec(Consumer<ExecSpec> execSpecConsumer) throws InterruptedException, IOException {
        ExecSpec execSpec = new ExecSpec();
        execSpecConsumer.accept(execSpec);
        return this.exec(execSpec);
    }

    public String execGetOutput(Consumer<ExecSpec> execSpecConsumer) throws IOException, InterruptedException {
        ExecSpec execSpec = new ExecSpec();
        execSpecConsumer.accept(execSpec);
        StringWriter writer = new StringWriter();
        execSpec.stdOut(writer);
        this.exec(execSpec);
        return writer.toString();
    }

    private int exec(ExecSpec execSpec) throws IOException, InterruptedException {
        CharSequence[] commandLine = new String[execSpec.getCommandLine().length + 2];
        commandLine[0] = "bash";
        commandLine[1] = "-c";
        System.arraycopy(execSpec.getCommandLine(), 0, commandLine, 2, execSpec.getCommandLine().length);
        if (this.trace) {
            System.err.println(String.join((CharSequence)" ", commandLine));
        }
        Process process = new ProcessBuilder(new String[0]).command((String[])commandLine).start();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        StringWriter stdErr = new StringWriter();
        threads.add(ExecUtils.createThread(process.getInputStream(), execSpec.getStdOut()));
        if (execSpec.getStdErr() != null) {
            threads.add(ExecUtils.createThread(process.getErrorStream(), execSpec.getStdErr()));
        } else {
            threads.add(ExecUtils.createThread(process.getErrorStream(), (Writer)stdErr));
        }
        ExecUtils.createThread(execSpec.getStdIn(), (Writer)new PrintWriter(process.getOutputStream()));
        int exit = process.waitFor();
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        if (!execSpec.isIgnoreErrors() && exit != 0) {
            throw new IOException("Command " + String.join((CharSequence)", ", commandLine) + " exited with " + exit + "\n" + stdErr.toString());
        }
        return exit;
    }

    private static Thread createThread(InputStream inputStream, Writer writer) {
        return ExecUtils.createThread(new InputStreamReader(inputStream), writer);
    }

    private static Thread createThread(Reader reader, Writer writer) {
        Thread thread = new Thread(new ProcessInteractor(reader, writer));
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static class ProcessInteractor
    implements Runnable {
        private final Reader reader;
        private final Writer writer;
        private final String waitFor;
        private final Semaphore lock;

        ProcessInteractor(Reader reader, Writer writer) {
            this(reader, writer, null);
        }

        ProcessInteractor(Reader reader, Writer writer, String waitFor) {
            this.reader = reader;
            this.writer = writer;
            this.waitFor = waitFor;
            this.lock = waitFor != null ? new Semaphore(0) : new Semaphore(1000);
        }

        @Override
        public void run() {
            StringBuilder lastLine = new StringBuilder();
            try {
                int c;
                while ((c = this.reader.read()) != -1) {
                    if ((char)c == '\n' && this.waitFor != null) {
                        if (this.waitFor.equals(lastLine.toString())) {
                            this.lock.release();
                        }
                        lastLine = new StringBuilder();
                    } else {
                        lastLine.append((char)c);
                    }
                    this.writer.write(c);
                    this.writer.flush();
                }
            }
            catch (IOException e) {
                this.lock.release();
            }
        }
    }
}

