/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.util;

import com.google.common.collect.ObjectArrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StackInformation
implements Comparable<StackInformation> {
    private static final Logger logger = LoggerFactory.getLogger(StackInformation.class);
    private static final String[] excludes = new String[]{"java.lang", "com.ericsson.lwac.transaction", "com.ericsson.lwac.monitoring", "org.eclipse.jetty"};
    private final Thread thread;
    private final String checksum;
    private int invocations = 1;
    private final List<StackTraceElement> stacks;

    public StackInformation(Thread thread, String checksum, List<StackTraceElement> stacks) {
        this.thread = thread;
        this.stacks = stacks;
        this.checksum = checksum;
    }

    public void increaseInvocations() {
        ++this.invocations;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getInvocations() {
        return this.invocations;
    }

    public List<StackTraceElement> getStacks() {
        return this.stacks;
    }

    public String getChecksum() {
        return this.checksum;
    }

    @Override
    public int compareTo(StackInformation o) {
        Objects.requireNonNull(o);
        return this.invocations - o.invocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackInformation that = (StackInformation)o;
        return this.invocations == that.invocations;
    }

    public int hashCode() {
        return Objects.hash(this.invocations);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(1024);
        for (StackTraceElement element : this.getStacks()) {
            switch (this.getThread().getState()) {
                case BLOCKED: 
                case WAITING: 
                case TIMED_WAITING: {
                    Object blocker;
                    if (!element.getClassName().equals(LockSupport.class.getName()) || (blocker = LockSupport.getBlocker(this.getThread())) == null) break;
                    builder.append(String.format("- parking to wait for  <%s> (a %s)%n", System.identityHashCode(blocker), blocker.getClass().getName()));
                    break;
                }
            }
            if (element.isNativeMethod()) {
                builder.append(String.format("%s.%s(Native Method)%n", element.getClassName(), element.getMethodName()));
                continue;
            }
            if (element.getFileName() == null && element.getLineNumber() == -1) {
                builder.append(String.format("%s.%s(Unknown Source)%n", element.getClassName(), element.getMethodName()));
                continue;
            }
            builder.append(String.format("%s.%s(%s:%d)%n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
        }
        return builder.toString();
    }

    public static Optional<StackInformation> create(Thread thread, StackTraceElement[] stackTrace, boolean filter, String ... extraExcludes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            boolean quiet = false;
            LinkedList<StackTraceElement> filteredStacktraceElements = new LinkedList<StackTraceElement>();
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (filter) {
                    if (className.startsWith("sun.reflect") && !quiet) {
                        quiet = true;
                        continue;
                    }
                    if (className.startsWith("com.ericsson.lwac.remote") && quiet) {
                        quiet = false;
                    } else {
                        if (className.startsWith("com.sun.proxy") && quiet) {
                            quiet = false;
                            continue;
                        }
                        if (quiet) continue;
                    }
                    boolean skip = false;
                    for (String excluded : ObjectArrays.concat(excludes, extraExcludes, String.class)) {
                        if (!className.startsWith(excluded)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                filteredStacktraceElements.add(element);
                md.update(String.format("%s_%s_%s_%d", className, element.getMethodName(), element.getFileName(), element.getLineNumber()).getBytes("UTF-8"));
            }
            BigInteger number = new BigInteger(1, md.digest());
            String checkSum = number.toString(16);
            return Optional.of(new StackInformation(thread, checkSum, filteredStacktraceElements));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.trace("Could not get connection stack", e);
            return Optional.empty();
        }
    }
}

