/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.timer;

import com.ericsson.lwac.cluster.ClusterId;
import com.ericsson.lwac.timer.TimerExecutionStatus;
import com.ericsson.lwac.timer.TimerState;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public class TimerData
implements Serializable {
    private static final long serialVersionUID = 89237456320459L;
    private final String timerId;
    private final ClusterId localId;
    private ZonedDateTime lastStarted;
    private ZonedDateTime lastSuccess;
    private ZonedDateTime lastFailed;
    private Duration lastDuration;
    private TimerState state = TimerState.IDLE;
    private TimerExecutionStatus lastStatus;

    public TimerData(String timerId, ClusterId localId) {
        this.timerId = timerId;
        this.localId = localId;
    }

    public String getTimerId() {
        return this.timerId;
    }

    public Optional<ZonedDateTime> getLastStarted() {
        return Optional.ofNullable(this.lastStarted);
    }

    public Optional<ZonedDateTime> getLastSuccess() {
        return Optional.ofNullable(this.lastSuccess);
    }

    public Optional<ZonedDateTime> getLastFailed() {
        return Optional.ofNullable(this.lastFailed);
    }

    public ClusterId getLocalId() {
        return this.localId;
    }

    public Optional<Duration> getLastDuration() {
        return Optional.ofNullable(this.lastDuration);
    }

    public TimerState getState() {
        return this.state;
    }

    public Optional<TimerExecutionStatus> getLastStatus() {
        return Optional.ofNullable(this.lastStatus);
    }

    public void setLastStarted(ZonedDateTime lastStarted) {
        this.lastStarted = lastStarted;
    }

    public void setLastSuccess(ZonedDateTime lastSuccess) {
        this.lastSuccess = lastSuccess;
    }

    public void setLastFailed(ZonedDateTime lastFailed) {
        this.lastFailed = lastFailed;
    }

    public void setLastDuration(Duration lastDuration) {
        this.lastDuration = lastDuration;
    }

    public void setState(TimerState state) {
        this.state = state;
    }

    public void setLastStatus(TimerExecutionStatus lastStatus) {
        this.lastStatus = lastStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerData timerData = (TimerData)o;
        return Objects.equals(this.timerId, timerData.timerId) && Objects.equals(this.localId, timerData.localId) && Objects.equals(this.lastStarted, timerData.lastStarted) && Objects.equals(this.lastSuccess, timerData.lastSuccess) && Objects.equals(this.lastFailed, timerData.lastFailed) && Objects.equals(this.lastDuration, timerData.lastDuration) && Objects.equals(this.state, timerData.state) && Objects.equals(this.lastStatus, timerData.lastStatus);
    }

    public int hashCode() {
        return Objects.hash(this.timerId, this.localId, this.lastStarted, this.lastSuccess, this.lastFailed, this.lastDuration, this.state, this.lastStatus);
    }
}

