/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.trace;

import java.util.Optional;
import java.util.UUID;

public final class HttpResponseTraceRecord {
    private final UUID uniqueId;
    private final Long sessionId;
    private final Long loggingTimeEpochMilliseconds;
    private final String responseBody;
    private final int responseStatus;

    private HttpResponseTraceRecord(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.sessionId = builder.sessionId;
        this.loggingTimeEpochMilliseconds = builder.loggingTimeEpochMilliseconds;
        this.responseBody = builder.responseBody;
        this.responseStatus = builder.responseStatus;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public Optional<Long> getSessionId() {
        return Optional.ofNullable(this.sessionId);
    }

    public Optional<Long> getLoggingTimeEpochMilliseconds() {
        return Optional.ofNullable(this.loggingTimeEpochMilliseconds);
    }

    public Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID uniqueId;
        private Long sessionId;
        private Long loggingTimeEpochMilliseconds;
        private String responseBody;
        private int responseStatus;

        Builder() {
        }

        public Builder uniqueId(UUID val) {
            this.uniqueId = val;
            return this;
        }

        public Builder sessionId(Long val) {
            this.sessionId = val;
            return this;
        }

        public Builder loggingTimeEpochMilliseconds(Long val) {
            this.loggingTimeEpochMilliseconds = val;
            return this;
        }

        public Builder responseBody(String val) {
            this.responseBody = val;
            return this;
        }

        public Builder responseStatus(int val) {
            this.responseStatus = val;
            return this;
        }

        public HttpResponseTraceRecord build() {
            return new HttpResponseTraceRecord(this);
        }
    }
}

