/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.net.http.client.HttpResponse;
import com.ericsson.lwac.net.http.client.security.ClientResponseWrapper;
import com.ericsson.lwac.net.http.core.security.SignerProviderException;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.Optional;

public class HttpResponseWrapper
implements ClientResponseWrapper {
    private final HttpResponse response;

    public HttpResponseWrapper(HttpResponse response) {
        this.response = response;
    }

    @Override
    @Nullable
    public String getHeader(String headerName) {
        return this.response.getHeaders().flatMap(headers -> headers.findFirst(headerName)).orElse(null);
    }

    @Override
    public InputStream getResponseStream() {
        return this.response.getContentAsStream().orElseThrow(() -> new SignerProviderException("Failed to read http entity content"));
    }

    @Override
    public Optional<Integer> getHttpStatusCode() {
        return Optional.of(this.response.getStatus().getValue());
    }
}

