/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.ericsson.lwac.net.http.core.HttpResponseCode;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class HttpResponse {
    @NotNull
    private final HttpResponseCode status;
    @Valid
    private final MediaType contentType;
    @Valid
    private final ByteBuffer content;
    @Valid
    private final HttpHeaders headers;

    protected HttpResponse(Builder builder) {
        this.status = builder.status;
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.headers = builder.headers;
    }

    public boolean isOK() {
        return HttpResponseCode.OK.equals((Object)this.status);
    }

    public HttpResponseCode getStatus() {
        return this.status;
    }

    public Optional<MediaType> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public Optional<ByteBuffer> getContent() {
        return Optional.ofNullable(this.content);
    }

    public Optional<InputStream> getContentAsStream() {
        return Optional.ofNullable(this.content).map(ByteBuffer::array).map(ByteArrayInputStream::new);
    }

    public Optional<HttpHeaders> getHeaders() {
        return Optional.ofNullable(this.headers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static HttpResponse ok(MediaType contentType, String content) {
        return HttpResponse.newBuilder().status(HttpResponseCode.OK).contentType(contentType).content(content, contentType.charset().or(StandardCharsets.UTF_8)).build();
    }

    public static HttpResponse ok(MediaType contentType, ByteBuffer content) {
        return HttpResponse.newBuilder().status(HttpResponseCode.OK).contentType(contentType).content(content).build();
    }

    public static HttpResponse error(MediaType contentType, String content) {
        return HttpResponse.newBuilder().status(HttpResponseCode.INTERNAL_SERVER_ERROR).contentType(contentType).content(content, contentType.charset().or(StandardCharsets.UTF_8)).build();
    }

    public static HttpResponse error(MediaType contentType, ByteBuffer content) {
        return HttpResponse.newBuilder().status(HttpResponseCode.INTERNAL_SERVER_ERROR).contentType(contentType).content(content).build();
    }

    public static final class Builder {
        private HttpResponseCode status;
        private MediaType contentType;
        private ByteBuffer content;
        private HttpHeaders headers;

        public Builder status(HttpResponseCode status) {
            this.status = status;
            return this;
        }

        public Builder contentType(MediaType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder content(ByteBuffer content) {
            this.content = content;
            return this;
        }

        public Builder content(String content, Charset charset) {
            this.content = ByteBuffer.wrap(content.getBytes(charset));
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public HttpResponse build() {
            Preconditions.checkNotNull(this.status, "'status' is invalid, can not be null");
            return new HttpResponse(this);
        }
    }
}

