/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.net.http.client.HttpRequest;
import com.ericsson.lwac.net.http.client.security.ClientRequestWrapper;
import com.ericsson.lwac.net.http.core.HttpHeader;
import com.ericsson.lwac.net.http.core.HttpHeaders;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class HttpRequestWrapper
implements ClientRequestWrapper {
    private final HttpRequest request;

    public HttpRequestWrapper(HttpRequest request) {
        this.request = request;
    }

    @Override
    public void setHeader(String headerName, String headerValue) {
        this.request.setHeader(HttpHeader.fromNameAndValue(headerName, headerValue));
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public InputStream getRequestStream() {
        String body = Optional.ofNullable(this.request.getBody()).orElse("");
        return new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
    }
}

