/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.client;

import com.ericsson.lwac.deployer.service.ServiceLifecycle;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.ericsson.lwac.deployer.service.ServiceStartException;
import com.ericsson.lwac.deployer.service.ServiceStopException;
import com.ericsson.lwac.kubernetes.SecretPath;
import com.ericsson.lwac.net.http.client.HttpClient;
import com.ericsson.lwac.net.http.client.HttpClientConfiguration;
import com.ericsson.lwac.net.http.client.HttpClientFactoryService;
import com.ericsson.lwac.net.http.client.HttpClientRegistry;
import com.ericsson.lwac.net.http.client.HttpClientRequestListener;
import com.ericsson.lwac.net.http.client.HttpClientResponseListener;
import com.ericsson.lwac.net.http.client.HttpClientService;
import com.ericsson.lwac.net.http.client.HttpRequest;
import com.ericsson.lwac.net.http.client.HttpRequestWrapper;
import com.ericsson.lwac.net.http.client.HttpResponse;
import com.ericsson.lwac.net.http.client.HttpResponseWrapper;
import com.ericsson.lwac.net.http.client.security.ClientSignerProvider;
import com.ericsson.lwac.net.http.core.security.SigningChallenge;
import com.ericsson.lwac.security.keystore.PemKeyStoreService;
import com.ericsson.lwac.security.keystore.RemoteKeyStoreService;
import com.ericsson.lwac.security.keystore.SSLContextDefinition;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientService
implements ServiceLifecycle,
HttpClientService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpClientService.class);
    private HttpClient httpClient;
    private ClientSignerProvider clientSignerProvider;
    private String signerProviderName;
    private int idleTime = 30;
    private int idleTimeCheck = 30;
    private int maxPoolSize = 200;
    private Integer maxPoolUsagePerHost;
    private int maximumConnectionKeepAliveTimeInSeconds = -1;
    private int connectionTimeout = 10;
    private boolean useTls = false;
    private HttpClientService.KeyManagementType keyManagementType = HttpClientService.KeyManagementType.PEM;
    private String keystoreName;
    private SecretPath tlsKeystoreSecretPath;
    private SecretPath tlsKeystorePasswordSecretPath;
    private String tlsKeystoreType = "PKCS12";
    private final List<HttpClientRequestListener> requestListeners = new CopyOnWriteArrayList<HttpClientRequestListener>();
    private final List<HttpClientResponseListener> responseListeners = new CopyOnWriteArrayList<HttpClientResponseListener>();
    @EJB
    private HttpClientRegistry httpClientRegistry;
    @Resource
    private HttpClientFactoryService httpClientFactoryService;
    @Resource
    private PemKeyStoreService pemKeyStoreService;
    @Resource
    private RemoteKeyStoreService remoteKeyStoreService;

    @VisibleForTesting
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public List<HttpClientRequestListener> getRequestListeners() {
        return this.requestListeners;
    }

    public List<HttpClientResponseListener> getResponseListeners() {
        return this.responseListeners;
    }

    @ServiceProperty
    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @ServiceProperty
    public void setMaxPoolUsagePerHost(int maxPoolUsagePerHost) {
        this.maxPoolUsagePerHost = maxPoolUsagePerHost;
    }

    @ServiceProperty
    public void setMaximumConnectionKeepAliveTimeInSeconds(int maximumConnectionKeepAliveTimeInSeconds) {
        this.maximumConnectionKeepAliveTimeInSeconds = maximumConnectionKeepAliveTimeInSeconds;
    }

    @ServiceProperty
    public void setConnectionTimeout(int seconds) {
        this.connectionTimeout = seconds;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @ServiceProperty
    public void setIdleTime(int seconds) {
        this.idleTime = seconds;
    }

    @ServiceProperty
    public void setIdleTimeCheck(int seconds) {
        this.idleTimeCheck = seconds;
    }

    @ServiceProperty
    public void setSignerProviderName(String signerProviderName) {
        this.signerProviderName = signerProviderName;
    }

    @ServiceProperty
    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    @ServiceProperty
    public void setTlsKeystorePath(String tlsKeystoreSecretPath) {
        this.tlsKeystoreSecretPath = SecretPath.create(tlsKeystoreSecretPath);
    }

    @ServiceProperty
    public void setTlsKeystoreType(String tlsKeystoreType) {
        this.tlsKeystoreType = tlsKeystoreType;
    }

    @ServiceProperty
    public void setTlsKeystorePasswordSecretPath(String tlsKeystorePasswordSecretPath) {
        this.tlsKeystorePasswordSecretPath = SecretPath.create(tlsKeystorePasswordSecretPath);
    }

    @ServiceProperty(defaultValue="PEM", description="Key management type, PEM or KEYSTORE.")
    public void setKeyManagementType(String type) {
        this.keyManagementType = HttpClientService.KeyManagementType.valueOf(type);
    }

    @ServiceProperty(description="Key store name in case key management type is PEM")
    public void setKeystoreName(String keystoreName) {
        this.keystoreName = keystoreName;
    }

    protected boolean isUseTls() {
        return this.useTls;
    }

    @Override
    public void start() throws ServiceStartException {
        this.httpClientRegistry.register(this);
        if (this.signerProviderName != null) {
            try {
                this.clientSignerProvider = (ClientSignerProvider)new InitialContext().lookup(this.signerProviderName);
            }
            catch (NamingException e) {
                throw new ServiceStartException("Failed to lookup signerProvider", e);
            }
        }
        HttpClientConfiguration.Builder builder = HttpClientConfiguration.newBuilder().connectionTimeout(this.connectionTimeout, TimeUnit.SECONDS).maxConnections(this.maxPoolSize).maxConnectionsPerHost(this.maxPoolUsagePerHost).idleTime(this.idleTime, TimeUnit.SECONDS).idleTimeCheckInterval(this.idleTimeCheck, TimeUnit.SECONDS).maximumConnectionKeepAliveTime(this.maximumConnectionKeepAliveTimeInSeconds, TimeUnit.SECONDS);
        if (this.useTls) {
            SSLContextDefinition definition;
            if (this.keyManagementType == HttpClientService.KeyManagementType.PEM) {
                definition = this.pemKeyStoreService.newPemKeyStoreBuilder().type(PemKeyStoreService.KeyStoreType.CLIENT).name(this.keystoreName).build().newSSLContextDefinitionBuilder().build();
            } else if (this.keyManagementType == HttpClientService.KeyManagementType.KEYSTORE) {
                logger.info("Using remote keystore based tls store: {}", (Object)this.tlsKeystoreSecretPath);
                definition = this.remoteKeyStoreService.newRemoteKeyStoreBuilder().keyStorePath(this.tlsKeystoreSecretPath).passwordPath(this.tlsKeystorePasswordSecretPath).keyStoreType(this.tlsKeystoreType).build().newSSLContextDefinitionBuilder().build();
            } else {
                logger.info("Using remote legacy keystore based tls store");
                definition = this.remoteKeyStoreService.getGenericTlsKeystore().newSSLContextDefinitionBuilder().build();
            }
            builder.sslContext(definition.getSSLContext());
        }
        this.customize(builder);
        this.httpClient = this.httpClientFactoryService.createClient(builder.build());
    }

    @Override
    public void stop() throws ServiceStopException {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.debug("Cannot close HttpClient", e);
            throw new ServiceStopException("Failure while stopping HttpClient", e);
        }
    }

    @Override
    public void addRequestListener(HttpClientRequestListener listener) {
        this.requestListeners.remove(listener);
        this.requestListeners.add(listener);
    }

    @Override
    public void addResponseListener(HttpClientResponseListener listener) {
        this.responseListeners.remove(listener);
        this.responseListeners.add(listener);
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void customize(HttpClientConfiguration.Builder builder) {
    }

    protected SigningChallenge signRequest(Class requestClass, HttpRequest httpRequest) {
        SigningChallenge signingChallenge = null;
        if (this.clientSignerProvider != null) {
            signingChallenge = this.clientSignerProvider.signMessage(new HttpRequestWrapper(httpRequest), requestClass);
        }
        return signingChallenge;
    }

    protected void verifyResponse(Class responseClass, SigningChallenge signingChallenge, HttpResponse response) {
        if (this.clientSignerProvider != null) {
            this.clientSignerProvider.verifyMessage(new HttpResponseWrapper(response), responseClass, signingChallenge);
        }
    }
}

