/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml.listener;

import com.ericsson.lwac.http.xml.listener.RequestListener;
import com.ericsson.lwac.http.xml.listener.RequestRecord;
import com.ericsson.lwac.http.xml.listener.RequestResponseListenerManager;
import com.ericsson.lwac.http.xml.listener.ResponseListener;
import com.ericsson.lwac.http.xml.listener.ResponseRecord;
import jakarta.ejb.Singleton;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

@Singleton
public class RequestResponseListenerManagerBean
implements RequestResponseListenerManager {
    private List<RequestListener> requestListeners = new CopyOnWriteArrayList<RequestListener>();
    private List<ResponseListener> responseListeners = new CopyOnWriteArrayList<ResponseListener>();
    private final ReentrantLock requestWriteLock = new ReentrantLock();
    private final ReentrantLock responseWriteLock = new ReentrantLock();

    @Override
    public void addListener(RequestListener listener) {
        this.requestWriteLock.lock();
        try {
            LinkedList<RequestListener> copy = new LinkedList<RequestListener>(this.requestListeners);
            copy.add(listener);
            copy.sort((o1, o2) -> Short.compare(o2.getWeight(), o1.getWeight()));
            this.requestListeners = new CopyOnWriteArrayList<RequestListener>(copy);
        }
        finally {
            this.requestWriteLock.unlock();
        }
    }

    @Override
    public void addListener(ResponseListener listener) {
        this.responseWriteLock.lock();
        try {
            LinkedList<ResponseListener> copy = new LinkedList<ResponseListener>(this.responseListeners);
            copy.add(listener);
            copy.sort((o1, o2) -> Short.compare(o2.getWeight(), o1.getWeight()));
            this.responseListeners = new CopyOnWriteArrayList<ResponseListener>(copy);
        }
        finally {
            this.responseWriteLock.unlock();
        }
    }

    @Override
    public void publish(RequestRecord record) {
        for (RequestListener listener : this.requestListeners) {
            listener.onRequest(record);
        }
    }

    @Override
    public void publish(ResponseRecord record) {
        for (ResponseListener listener : this.responseListeners) {
            listener.onResponse(record);
        }
    }
}

