/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml.async;

import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.core.HttpMethodNotAllowedException;
import com.ericsson.lwac.http.xml.async.AbstractAsyncAdvancedXmlOperation;
import com.ericsson.lwac.http.xml.async.AsyncXmlOperation;
import jakarta.annotation.Resource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public abstract class AbstractAsyncXmlOperation<Rq, Rs>
extends AbstractAsyncAdvancedXmlOperation<Rq, Rs>
implements AsyncXmlOperation<Rq, Rs> {
    private static final int TYPE_ARGUMENT_REQUEST = 0;
    private static final int TYPE_ARGUMENT_RESPONSE = 1;
    @Resource
    private ApplicationContext applicationContext;
    private Class<Rq> classRq;
    private Class<Rs> classRs;
    private AsyncXmlOperation<Rq, Rs> instance;

    protected AbstractAsyncXmlOperation() {
    }

    @Override
    public Class<?>[] getRequestResponseClasses() {
        return new Class[]{this.getRequestClass(), this.getResponseClass()};
    }

    @Override
    @Nonnull
    public CompletableFuture<?> handleAsync(HttpOperationRequest httpOperationRequest, HttpOperationResponse httpOperationResponse, Rq request) {
        if (httpOperationRequest.getHttpMethod() != HttpOperationRequest.HttpMethod.POST) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally((Throwable)new HttpMethodNotAllowedException("Only HTTP POST supported"));
            return future;
        }
        if (this.instance == null) {
            this.instance = (AsyncXmlOperation)this.applicationContext.getThis();
        }
        return this.instance.handleAsync(request);
    }

    public Class<Rq> getRequestClass() {
        if (this.classRq == null) {
            this.classRq = (Class)this.getType(0);
        }
        return this.classRq;
    }

    public Class<Rs> getResponseClass() {
        if (this.classRs == null) {
            this.classRs = (Class)this.getType(1);
        }
        return this.classRs;
    }

    private Type getType(int typeArgument) {
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[typeArgument];
    }
}

