/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.core.HttpMethodNotAllowedException;
import com.ericsson.lwac.http.xml.AbstractAdvancedXmlOperation;
import com.ericsson.lwac.http.xml.XmlOperation;
import jakarta.annotation.Resource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractXmlOperation<Rq, Rs>
extends AbstractAdvancedXmlOperation
implements XmlOperation<Rq, Rs> {
    private static final int TYPE_ARGUMENT_REQUEST = 0;
    private static final int TYPE_ARGUMENT_RESPONSE = 1;
    @Resource
    private ApplicationContext applicationContext;
    private Class<Rq> classRq;
    private Class<Rs> classRs;
    private XmlOperation<Rq, Rs> instance;

    protected AbstractXmlOperation() {
    }

    @Override
    public Class<?>[] getRequestResponseClasses() {
        return new Class[]{this.getRequestClass(), this.getResponseClass()};
    }

    public <Rms, Rmq> Rms handle(HttpOperationRequest httpOperationRequest, HttpOperationResponse httpOperationResponse, Rmq request) throws Exception {
        if (httpOperationRequest.getHttpMethod() != HttpOperationRequest.HttpMethod.POST) {
            throw new HttpMethodNotAllowedException("Only HTTP POST supported");
        }
        if (this.instance == null) {
            this.instance = (XmlOperation)this.applicationContext.getThis();
        }
        return (Rms)this.instance.handle(request);
    }

    public Class<Rq> getRequestClass() {
        if (this.classRq == null) {
            this.classRq = (Class)this.getType(0);
        }
        return this.classRq;
    }

    public Class<Rs> getResponseClass() {
        if (this.classRs == null) {
            this.classRs = (Class)this.getType(1);
        }
        return this.classRs;
    }

    private Type getType(int typeArgument) {
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[typeArgument];
    }
}

