/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.ws;

import com.ericsson.lwac.http.ws.BaseWebSocketOperation;
import com.ericsson.lwac.http.ws.WebSocketOperationSessionData;
import com.ericsson.lwac.net.ws.WebSocketMessagingChannel;
import com.ericsson.lwac.net.ws.core.WebSocketCloseCode;
import com.ericsson.lwac.net.ws.core.WebSocketSubProtocol;
import com.ericsson.lwac.net.ws.exchange.WebSocketMessage;
import com.ericsson.lwac.net.ws.server.WebSocketEndpointSession;
import com.ericsson.lwac.net.ws.server.WebSocketEndpointSessionBuilder;
import com.ericsson.lwac.net.ws.server.WebSocketServerHandler;
import com.google.common.base.Preconditions;
import java.util.Optional;

public final class WebSocketOperationEndpointSession<S extends WebSocketOperationSessionData>
implements WebSocketServerHandler,
WebSocketEndpointSession {
    private final BaseWebSocketOperation<S> operation;
    private final S sessionData;

    public WebSocketOperationEndpointSession(Builder<S> builder) {
        this.operation = builder.operation;
        this.sessionData = builder.sessionData;
    }

    @Override
    public Optional<WebSocketServerHandler> getHandler() {
        return Optional.of(this);
    }

    @Override
    public void onClose(WebSocketMessagingChannel channel, WebSocketCloseCode webSocketCloseCode) {
        this.operation.onSessionClose(this.sessionData);
    }

    @Override
    public void onReceivedMessage(WebSocketMessagingChannel channel, WebSocketMessage message) {
        this.operation.onMessage(this.sessionData, channel, message);
    }

    public static <T extends WebSocketOperationSessionData> Builder<T> newBuilder(T sessionData) {
        Preconditions.checkNotNull(sessionData, "'sessionData' is invalid, can not be null");
        return new Builder<T>(sessionData);
    }

    public static final class Builder<T extends WebSocketOperationSessionData>
    implements WebSocketEndpointSessionBuilder {
        private final T sessionData;
        private WebSocketMessagingChannel channel;
        private BaseWebSocketOperation<T> operation;

        private Builder(T sessionData) {
            this.sessionData = sessionData;
        }

        @Override
        public Builder<T> channel(WebSocketMessagingChannel channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public Builder<T> subProtocol(WebSocketSubProtocol ignored) {
            return this;
        }

        public Builder<T> operation(BaseWebSocketOperation<T> operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public WebSocketEndpointSession build() {
            WebSocketOperationEndpointSession session = new WebSocketOperationEndpointSession(this);
            this.operation.onSessionOpen(this.sessionData, this.channel);
            return session;
        }
    }
}

