/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.ws;

import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.ericsson.lwac.net.http.core.HttpMethod;
import com.ericsson.lwac.net.http.core.HttpQueryParameters;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class WebSocketInitializationRequest {
    private final HttpMethod method;
    private final HttpHeaders headers;
    private final HttpQueryParameters queryParameters;
    private final String context;
    private final String sessionId;

    private WebSocketInitializationRequest(Builder builder) {
        this.method = builder.method;
        this.headers = builder.headers;
        this.queryParameters = builder.queryParameters;
        this.context = builder.context;
        this.sessionId = builder.sessionId;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpQueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public String getContext() {
        return this.context;
    }

    public Optional<String> getSessionId() {
        return Optional.ofNullable(this.sessionId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpMethod method;
        private HttpHeaders headers;
        private HttpQueryParameters queryParameters;
        private String context;
        private String sessionId;

        private Builder() {
        }

        public Builder method(HttpMethod val) {
            this.method = val;
            return this;
        }

        public Builder headers(HttpHeaders val) {
            this.headers = val;
            return this;
        }

        public Builder queryParameters(HttpQueryParameters val) {
            this.queryParameters = val;
            return this;
        }

        public Builder context(String val) {
            this.context = val;
            return this;
        }

        public Builder sessionId(String val) {
            this.sessionId = val;
            return this;
        }

        public WebSocketInitializationRequest build() {
            return new WebSocketInitializationRequest(this);
        }
    }
}

