/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.statistics;

import com.ericsson.lwac.http.statistics.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OperationContextInfo
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String className;
    private final String operationName;
    private final boolean isDeprecated;
    private final List<Context> contexts;
    private final String namespace;

    protected OperationContextInfo(String className, String operation, boolean isDeprecated, List<Context> contexts, String namespace) {
        this.className = className;
        this.operationName = operation;
        this.isDeprecated = isDeprecated;
        ArrayList<Context> c = new ArrayList<Context>(contexts.size());
        c.addAll(contexts);
        this.contexts = Collections.unmodifiableList(c);
        this.namespace = namespace;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static OperationContextInfo of(String className, String operation, boolean deprecated, List<Context> contexts, String namespace) {
        return new OperationContextInfo(className, operation, deprecated, contexts, namespace);
    }
}

