/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.statistics;

import com.ericsson.lwac.http.statistics.Context;
import com.ericsson.lwac.http.statistics.Interval;
import com.ericsson.lwac.http.statistics.LocalOperationStatistics;
import com.ericsson.lwac.http.statistics.OperationUsage;
import com.ericsson.lwac.http.statistics.WaitReportFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpOperationStatisticsCollector {
    public static final Logger logger = LoggerFactory.getLogger(HttpOperationStatisticsCollector.class);
    private final Map<Context, List<OperationUsage>> usage;
    private final List<Interval> intervals;
    private final Pattern csvFilePattern = Pattern.compile("wait-report-inc[a-z]+-(\\d{8}-\\d{4})-(\\d{8}-\\d{4})(\\.\\d+)?\\.csv");
    public static final DateTimeFormatter FILE_DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendYear(4, 4).appendMonthOfYear(2).appendDayOfMonth(2).appendLiteral('-').appendHourOfDay(2).appendMinuteOfHour(2).toFormatter();
    private static final Pattern CSV_OPERATION_STAT_PATTERN = Pattern.compile("^[-0-9T:]+;[-0-9T:]+;http\\.([^/]+)/([^/]+)/([0-9]+\\.[0-9]+);.*");
    private static final String OPERATION_EXCLUDE_PATTERN = "^login$|^logout$";

    public HttpOperationStatisticsCollector(Map<Context, List<OperationUsage>> operationUsagePerContext) {
        this.usage = operationUsagePerContext;
        this.intervals = new LinkedList<Interval>();
    }

    public void visitFile(File csvOrZipFile) throws IOException {
        String name = csvOrZipFile.getName();
        if (name.endsWith(".csv")) {
            this.visitCsvFile(csvOrZipFile);
        } else if (name.endsWith(".zip")) {
            this.visitZipFile(csvOrZipFile);
        } else {
            throw new IllegalArgumentException("Unsupported file type: " + name);
        }
    }

    public void visitCsvFile(File csv) throws IOException {
        if (this.csvFilePattern.matcher(csv.getName()).matches()) {
            try (FileInputStream in = new FileInputStream(csv);){
                this.visitContent(csv.getName(), in);
            }
        }
    }

    private void visitContent(String filename, InputStream in) throws IOException {
        Matcher matcher = this.csvFilePattern.matcher(filename);
        if (matcher.matches()) {
            DateTime from = DateTime.parse(matcher.group(1), FILE_DATETIME_FORMATTER);
            DateTime to = DateTime.parse(matcher.group(2), FILE_DATETIME_FORMATTER);
            Interval interval = Interval.of(from, to);
            this.intervals.add(interval);
            WaitReportFile file = WaitReportFile.of(filename, interval);
            this.parseStream(file, in, this.usage);
        }
    }

    public List<Interval> getVisitedIntervals() {
        ArrayList<Interval> result = new ArrayList<Interval>(this.intervals.size());
        result.addAll(this.intervals);
        Collections.sort(result);
        return result;
    }

    public Map<Context, List<OperationUsage>> getUsage() {
        return this.usage;
    }

    private void parseStream(WaitReportFile file, InputStream in, Map<Context, List<OperationUsage>> result) {
        Scanner scanner = new Scanner(in);
        while (scanner.hasNextLine()) {
            this.parseLine(file, result, scanner.nextLine());
        }
    }

    private void parseLine(WaitReportFile file, Map<Context, List<OperationUsage>> result, String s) {
        Matcher matcher = CSV_OPERATION_STAT_PATTERN.matcher(s);
        if (matcher.matches()) {
            String context = matcher.group(1);
            String operation = matcher.group(2);
            String version = matcher.group(3);
            List<OperationUsage> usages = result.get(Context.of(context));
            if (usages == null) {
                logger.warn("Strange wait report (file {}), context {} not present in service, but present in wait report: {}", file.getFileName(), context, s);
            } else {
                Optional<OperationUsage> opUsage = usages.stream().filter(op -> op.isOperationVersion(operation, version)).findFirst();
                if (opUsage.isPresent()) {
                    opUsage.get().markUsed(file);
                } else if (!operation.matches(OPERATION_EXCLUDE_PATTERN)) {
                    logger.warn("Strange wait report (file {}), found operation {} with version {}, but not present in context {}", file.getFileName(), operation, version, context);
                }
            }
        }
    }

    public void visitZipFile(File zip) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry nextEntry = in.getNextEntry();
            while (nextEntry != null) {
                if (this.csvFilePattern.matcher(nextEntry.getName()).matches()) {
                    this.visitContent(nextEntry.getName(), in);
                }
                nextEntry = in.getNextEntry();
            }
        }
    }

    public LocalOperationStatistics getLocalOperationStatistics() {
        return LocalOperationStatistics.of(this.usage, this.intervals);
    }
}

