/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli.domain;

import com.ericsson.lwac.http.cli.domain.AuthProvider;
import com.ericsson.lwac.http.cli.domain.OperationClass;
import com.ericsson.lwac.http.cli.domain.OperationContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HttpService
implements Serializable {
    private final String name;
    private final String beanClass;
    private final String context;
    private final AuthProvider authProvider;
    private final String errHandler;
    private final List<OperationClass> operationClasses;
    private final List<OperationContainer> operationContainers;
    private final boolean isEnabled;

    private HttpService(Builder builder) {
        this.name = builder.name;
        this.beanClass = builder.beanClass;
        this.context = builder.context;
        this.authProvider = builder.authProvider;
        this.errHandler = builder.errHandler;
        this.operationClasses = builder.operationClasses;
        this.operationContainers = builder.operationContainers;
        this.isEnabled = builder.isEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public String getContext() {
        return this.context;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public String getErrHandler() {
        return this.errHandler;
    }

    public List<OperationClass> getOperationClasses() {
        return this.operationClasses;
    }

    public List<OperationContainer> getOperationContainers() {
        return this.operationContainers;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpService that = (HttpService)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static final class Builder {
        private String name;
        private String beanClass;
        private String context;
        private AuthProvider authProvider;
        private String errHandler;
        private List<OperationClass> operationClasses = Collections.emptyList();
        private List<OperationContainer> operationContainers = new ArrayList<OperationContainer>();
        private boolean isEnabled = true;

        private Builder() {
        }

        public Builder name(String val) {
            this.name = val;
            return this;
        }

        public Builder beanClass(String beanClass) {
            this.beanClass = beanClass;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder authProvider(AuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder errHandler(String errHandler) {
            this.errHandler = errHandler;
            return this;
        }

        public Builder operationClasses(List<OperationClass> val) {
            this.operationClasses = val;
            return this;
        }

        public Builder operationContainers(List<OperationContainer> operationContainers) {
            this.operationContainers = operationContainers;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public HttpService build() {
            return new HttpService(this);
        }
    }
}

