/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import com.ericsson.lwac.http.cli.HttpContextManager;
import com.ericsson.lwac.http.cli.domain.HttpService;
import com.ericsson.lwac.http.cli.domain.OperationClass;
import com.ericsson.lwac.http.cli.domain.OperationContainer;
import com.ericsson.lwac.http.cli.domain.ServiceFile;
import com.ericsson.lwac.http.validators.IsRestrictedString;
import com.ericsson.lwac.utilities.cli.table.CLIHeaders;
import com.ericsson.lwac.utilities.cli.table.CLITable;
import com.google.common.base.Strings;
import jakarta.ejb.EJB;
import jakarta.validation.constraints.Pattern;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.joda.time.DateTime;
import org.xml.sax.SAXException;

@Command(name="context")
@RemoteCommand
@Parameters(separators="=")
public class HttpContextCommand {
    @Parameter(description="only check templates", names={"-t", "--templates"})
    private boolean onlyTemplates = false;
    private static final String TAB = "\t";
    @EJB
    private HttpContextManager httpContextManager;

    @Command(name="list")
    @Parameters(separators="=")
    private final class ListCommand
    implements RemoteAction {
        private static final String CONTEXT_COLUMN = "Context";
        private static final String FILE_COLUMN = "File";
        private static final String SERVICE_COLUMN = "Service";
        private static final String AUTH_PROVIDER_COLUMN = "Authentication Provider";
        private static final String ERR_HANDLER_COLUMN = "Error Handler";
        private static final String OPERATION_CONTAINERS_COLUMN = "Operation Containers";
        private static final String DISABLED_COLUMN = "Disabled";
        private static final String WHITE_SPACE = " ";
        private static final String EMPTY_STRING = "";
        private static final String ROW_SEPARATOR_CHAR = "-";
        @Parameter(description="Show additional details like Operation Container(s), properties of Authentication Provider.", names={"-v", "--verbose"})
        private boolean isListProperties;
        @Pattern(regexp="^[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an ASCII string, consisting of letters a-z, A-Z, digits 0-9, - or _.")
        @Parameter(description="Requires a mandatory context name. Like --verbose (-v), but only shows details of the input context. Also shows list of operation classes for the context.", names={"-o", "--operations-for-context"})
        private @Pattern(regexp="^[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an ASCII string, consisting of letters a-z, A-Z, digits 0-9, - or _.") String context;

        private ListCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) {
            List<ServiceFile> serviceFiles;
            if (this.context != null) {
                this.isListProperties = true;
            }
            try {
                serviceFiles = HttpContextCommand.this.httpContextManager.getContextServiceFiles(this.isListProperties, this.context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.printData(environment.getOutputWriter(), serviceFiles);
        }

        private void printData(PrintWriter out, List<ServiceFile> serviceFiles) {
            CLITable.Builder table = CLITable.create().name(EMPTY_STRING).header(new CLIHeaders(EMPTY_STRING, EMPTY_STRING));
            serviceFiles.forEach(sf -> sf.getHttpServices().forEach(httpService -> {
                if (this.context == null || this.context.equals(httpService.getContext())) {
                    table.row(CONTEXT_COLUMN, httpService.getContext());
                    table.row(FILE_COLUMN, sf.getPath());
                    table.row(SERVICE_COLUMN, httpService.getName());
                    this.printAuthProvider(table, (HttpService)httpService);
                    if (!httpService.isEnabled()) {
                        table.row(DISABLED_COLUMN, Boolean.TRUE.toString());
                        table.row(Strings.repeat(ROW_SEPARATOR_CHAR, 23), Strings.repeat(ROW_SEPARATOR_CHAR, 45));
                        return;
                    }
                    table.row(ERR_HANDLER_COLUMN, httpService.getErrHandler());
                    if (this.isListProperties) {
                        this.printVerboseInfo(table, (ServiceFile)sf, (HttpService)httpService);
                    }
                    table.row(Strings.repeat(ROW_SEPARATOR_CHAR, 23), Strings.repeat(ROW_SEPARATOR_CHAR, 45));
                }
            }));
            out.println(table.build());
            out.flush();
        }

        private void printAuthProvider(CLITable.Builder table, HttpService httpService) {
            table.row(AUTH_PROVIDER_COLUMN, httpService.getAuthProvider().getName());
            if (this.isListProperties && httpService.isEnabled()) {
                httpService.getAuthProvider().getProperties().forEach((key, value) -> table.row(EMPTY_STRING, Strings.repeat(WHITE_SPACE, 4) + key + " = " + value));
                table.row(EMPTY_STRING, EMPTY_STRING);
            }
        }

        private void printVerboseInfo(CLITable.Builder table, ServiceFile sf, HttpService httpService) {
            boolean isContainerHeadingPrinted = false;
            if (this.context != null && !httpService.getOperationClasses().isEmpty()) {
                table.row(EMPTY_STRING, EMPTY_STRING);
                table.row(OPERATION_CONTAINERS_COLUMN, "-- No Operation Container --");
                isContainerHeadingPrinted = true;
                table.row(EMPTY_STRING, Strings.repeat(WHITE_SPACE, 4) + sf.getPath());
                this.printOperationClasses(table, httpService.getOperationClasses());
            }
            for (OperationContainer opContainer : httpService.getOperationContainers()) {
                table.row(EMPTY_STRING, EMPTY_STRING);
                if (!isContainerHeadingPrinted) {
                    table.row(OPERATION_CONTAINERS_COLUMN, opContainer.getName());
                    isContainerHeadingPrinted = true;
                } else {
                    table.row(EMPTY_STRING, opContainer.getName());
                }
                table.row(EMPTY_STRING, Strings.repeat(WHITE_SPACE, 4) + opContainer.getPath());
                if (this.context == null) continue;
                this.printOperationClasses(table, opContainer.getOperationClasses());
            }
        }

        private void printOperationClasses(CLITable.Builder table, List<OperationClass> operationClasses) {
            operationClasses.forEach(opClass -> table.row(EMPTY_STRING, Strings.repeat(WHITE_SPACE, 8) + opClass.getShortName()));
        }
    }

    @Command(name="create")
    @Parameters(separators="=")
    private final class CreateCommand
    implements RemoteAction {
        @Parameter(description="overwrite original files, if present", names={"-f", "--force"})
        private boolean force;
        @Pattern(regexp="^[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an ASCII string, consisting of letters a-z, A-Z, digits 0-9, - or _.")
        @Parameter(description="context name", required=true, names={"-c", "--context"})
        private @Pattern(regexp="^[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an ASCII string, consisting of letters a-z, A-Z, digits 0-9, - or _.") String context;
        @Parameter(description="template file name or directory", required=true, names={"-t", "--template"})
        private String templateName;
        @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").")
        @Parameter(description="authentication provider service name", names={"-a", "--auth-provider"})
        private @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").") String authenticationProvider;
        @Pattern(regexp="^(?:[a-zA-Z][a-zA-Z0-9_]*+(?:[.][a-zA-Z][a-zA-Z0-9_]*+)*)*$", message="should be a regular Java class name, not an inner or anonymous class.")
        @Parameter(description="error handler class", names={"-e", "--error-handler"})
        private @Pattern(regexp="^(?:[a-zA-Z][a-zA-Z0-9_]*+(?:[.][a-zA-Z][a-zA-Z0-9_]*+)*)*$", message="should be a regular Java class name, not an inner or anonymous class.") String errorHandler;
        @IsRestrictedString
        @Parameter(description="comment", names={"--comment"})
        private String comment = "Created at " + String.valueOf(DateTime.now());

        private CreateCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            try {
                environment.getOutputWriter().println(HttpContextCommand.this.httpContextManager.create(this.templateName, this.context, this.authenticationProvider, this.errorHandler, this.comment, HttpContextCommand.this.onlyTemplates, this.force));
            }
            catch (IOException | ClassNotFoundException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new ExecutionException("Could not create context", e);
            }
        }
    }

    @Command(name="create-all")
    @Parameters(separators="=")
    private final class CreateAllCommand
    implements RemoteAction {
        @Parameter(description="overwrite original files, if present", names={"-f", "--force"})
        private boolean force;

        private CreateAllCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            try {
                environment.getOutputWriter().println(HttpContextCommand.this.httpContextManager.createAll(this.force));
            }
            catch (IOException e) {
                throw new ExecutionException("Could not create contexts", e);
            }
        }
    }
}

