/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.deployer.DeploymentException;
import com.ericsson.lwac.deployer.MainDeployer;
import com.ericsson.lwac.deployer.ObjectNotFoundException;
import com.ericsson.lwac.deployer.RequestContext;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceStartException;
import com.ericsson.lwac.http.HttpOperationContainer;
import com.ericsson.lwac.http.HttpOperationServiceBean;
import com.ericsson.lwac.http.LogoutOperation;
import com.ericsson.lwac.http.OperationClassInfo;
import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.SessionType;
import com.ericsson.lwac.http.core.HttpNotFoundException;
import com.ericsson.lwac.http.types.HttpOperationPath;
import com.ericsson.lwac.http.types.NameVersion;
import com.ericsson.lwac.http.types.Version;
import com.ericsson.lwac.http.ws.BaseWebSocketOperation;
import com.ericsson.lwac.http.ws.WebSocketInitializationRequest;
import com.ericsson.lwac.http.ws.WebSocketOperation;
import com.ericsson.lwac.http.ws.WebSocketOperationSessionData;
import com.ericsson.lwac.http.ws.WebSocketUpgradeCallContext;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import com.ericsson.lwac.net.http.HttpConnectorService;
import com.ericsson.lwac.net.http.core.HttpHeaders;
import com.ericsson.lwac.net.http.core.HttpMethod;
import com.ericsson.lwac.net.http.core.HttpQueryParameters;
import com.ericsson.lwac.net.http.core.HttpResponseCode;
import com.ericsson.lwac.net.ws.WebSocketMessagingChannel;
import com.ericsson.lwac.net.ws.core.WebSocketSubProtocol;
import com.ericsson.lwac.net.ws.exchange.WebSocketMessage;
import com.ericsson.lwac.net.ws.server.WebSocketEndpoint;
import com.ericsson.lwac.net.ws.server.WebSocketEndpointSessionBuilder;
import com.ericsson.lwac.net.ws.server.WebSocketMessageProtocol;
import com.ericsson.lwac.net.ws.server.WebSocketUpgradeRequest;
import com.ericsson.lwac.net.ws.server.WebSocketUpgradeResponse;
import com.ericsson.lwac.security.session.SessionManager;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(serviceInterface=WebSocketMessageProtocol.class)
public class WebSocketHttpOperationServiceBean
extends HttpOperationServiceBean
implements WebSocketMessageProtocol {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHttpOperationServiceBean.class);
    @Resource
    private MainDeployer mainDeployer;
    @Resource
    private StatisticsService statisticsService;
    @Resource
    private SessionManager sessionManager;
    @Resource
    private RequestContext requestContext;
    private List<OperationClassInfo> operationInfo;
    private List<WebSocketEndpoint> endpoints;

    @Override
    public void start() throws ServiceStartException {
        super.start();
        LinkedList<OperationClassInfo> operationClassNameVersions = new LinkedList<OperationClassInfo>();
        Set operationClasses = this.httpOperationContainers.stream().map(HttpOperationContainer::getOperationClasses).flatMap(Collection::stream).filter(Predicate.not(LogoutOperation.class.getName()::equals)).collect(Collectors.toSet());
        operationClasses.addAll(this.operationClasses);
        try {
            HashMap<String, WebSocketOperationEndpoint> endpointsBuilder = new HashMap<String, WebSocketOperationEndpoint>();
            for (String operationClass : operationClasses) {
                Version version = Version.fromClassName(operationClass);
                Object installedObject = this.mainDeployer.install(operationClass);
                if (!(installedObject instanceof WebSocketOperation)) continue;
                logger.debug("Adding {} v{} to {}", operationClass, version.toString(), this.getContext());
                WebSocketOperation wsOperation = (WebSocketOperation)installedObject;
                String endpointPath = wsOperation.getName();
                NameVersion nameVersion = new NameVersion(endpointPath, version);
                operationClassNameVersions.add(OperationClassInfo.of(operationClass, nameVersion));
                endpointsBuilder.computeIfAbsent(endpointPath, x$0 -> new WebSocketOperationEndpoint((String)x$0));
                if (!((WebSocketOperationEndpoint)endpointsBuilder.get(endpointPath)).addOperation(wsOperation)) continue;
                String message = String.format("Unsupported duplicated WebSocket path %s", endpointPath);
                throw new ServiceStartException(message);
            }
            this.endpoints = endpointsBuilder.values().stream().collect(Collectors.toUnmodifiableList());
        }
        catch (DeploymentException | ObjectNotFoundException e) {
            throw new ServiceStartException("Unable to start WebSocketHttpOperationService", e);
        }
        this.operationInfo = Collections.unmodifiableList(operationClassNameVersions);
    }

    @Override
    public Collection<WebSocketEndpoint> getEndPoints() {
        return this.endpoints;
    }

    @Override
    protected final void registerProtocol(HttpConnectorService httpConnectorService) {
        httpConnectorService.registerProtocol(this);
    }

    @Override
    public List<OperationClassInfo> getOperationClassInfo() {
        List<OperationClassInfo> httpOperations = super.getOperationClassInfo();
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(httpOperations)).addAll(this.operationInfo)).build();
    }

    private final class WebSocketOperationEndpoint
    implements WebSocketEndpoint {
        private final String endpointPath;
        private final Map<WebSocketSubProtocol, WebSocketOperation<WebSocketOperationSessionData>> operations = new HashMap<WebSocketSubProtocol, WebSocketOperation<WebSocketOperationSessionData>>();

        private WebSocketOperationEndpoint(String endpointPath) {
            this.endpointPath = endpointPath;
        }

        @Override
        public String getName() {
            return this.endpointPath;
        }

        @Override
        public String getPath() {
            if (this.endpointPath.startsWith("/")) {
                return this.endpointPath;
            }
            return "/" + this.endpointPath;
        }

        boolean addOperation(WebSocketOperation<WebSocketOperationSessionData> operation) {
            return this.operations.put(operation.getSubProtocol(), operation) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<WebSocketEndpointSessionBuilder> initializeSession(WebSocketUpgradeRequest webSocketUpgradeRequest, WebSocketUpgradeResponse webSocketUpgradeResponse) {
            block7: {
                Optional<WebSocketEndpointSessionBuilder> optional;
                HttpOperationPath path;
                WebSocketOperation operation;
                Measurement measurement;
                String operationName;
                WebSocketUpgradeCallContext callContext;
                RequestCorrelationId correlationId;
                long startTime;
                block6: {
                    startTime = System.nanoTime();
                    correlationId = new RequestCorrelationId();
                    callContext = new WebSocketUpgradeCallContext(webSocketUpgradeRequest, webSocketUpgradeResponse);
                    operationName = null;
                    measurement = null;
                    operation = webSocketUpgradeRequest.getRequestedSubProtocols().stream().map(this.operations::get).filter(Objects::nonNull).findAny().orElse(new NotFound(){

                        @Override
                        public WebSocketOperationSessionData onSessionInitialization(WebSocketInitializationRequest initializationRequest) throws Exception {
                            throw new HttpNotFoundException("Could not find operation " + WebSocketOperationEndpoint.this.endpointPath);
                        }
                    });
                    webSocketUpgradeResponse.setAcceptedSubProtocol(operation.getSubProtocol());
                    path = WebSocketHttpOperationServiceBean.this.getHttpOperationPath(callContext);
                    operationName = path.getOperationName();
                    Version version = operation.getSubProtocol().getVersion().map(Version::new).orElse(null);
                    measurement = WebSocketHttpOperationServiceBean.this.statisticsService.startMeasurment("ws-initialize", this.getMeasurementName(operationName, version), StatisticsService.MeasurementType.INCOMING, StatisticsService.UsageType.PERFORMANCE);
                    String authorization = callContext.getRequest().getHeader("Authorization");
                    WebSocketHttpOperationServiceBean.this.parseCookies(callContext);
                    WebSocketHttpOperationServiceBean.this.validateEitherSessionOrAuthorization(callContext, authorization);
                    if (WebSocketHttpOperationServiceBean.this.handleAuthentication(callContext, authorization, operation)) break block6;
                    webSocketUpgradeResponse.setErrorResponse(HttpResponseCode.UNAUTHORIZED, null);
                    Optional<WebSocketEndpointSessionBuilder> optional2 = Optional.empty();
                    WebSocketHttpOperationServiceBean.this.finalizeRequest(callContext, measurement);
                    WebSocketHttpOperationServiceBean.this.sessionManager.reset();
                    WebSocketHttpOperationServiceBean.this.requestContext.reset();
                    return optional2;
                }
                try {
                    HttpQueryParameters queryParameters = webSocketUpgradeRequest.getAsServletRequest().getParameterMap().entrySet().stream().map(entry -> HttpQueryParameters.fromNameAndValues((String)entry.getKey(), Arrays.asList((String[])entry.getValue()))).collect(HttpQueryParameters.collector());
                    HttpHeaders.Builder headers = HttpHeaders.newBuilder();
                    WebSocketHttpOperationServiceBean.this.parseHeaders(callContext).forEach(headers::header);
                    String context = path.getContext();
                    String sessionContextName = String.format("http-%s", context);
                    WebSocketInitializationRequest initializationRequest = WebSocketInitializationRequest.newBuilder().method(HttpMethod.valueOf(callContext.getRealRequest().getMethod())).queryParameters(queryParameters).headers(headers.build()).context(sessionContextName).sessionId(callContext.getSessionId()).build();
                    Object sessionData = operation.onSessionInitialization(initializationRequest);
                    optional = Optional.of(operation.newSessionBuilder(sessionData));
                }
                catch (Throwable throwable) {
                    try {
                        WebSocketHttpOperationServiceBean.this.handleThrowable(correlationId, operationName, Version.DEFAULT_VERSION, measurement, startTime, callContext, throwable);
                        break block7;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        WebSocketHttpOperationServiceBean.this.finalizeRequest(callContext, measurement);
                        WebSocketHttpOperationServiceBean.this.sessionManager.reset();
                        WebSocketHttpOperationServiceBean.this.requestContext.reset();
                    }
                }
                WebSocketHttpOperationServiceBean.this.finalizeRequest(callContext, measurement);
                WebSocketHttpOperationServiceBean.this.sessionManager.reset();
                WebSocketHttpOperationServiceBean.this.requestContext.reset();
                return optional;
            }
            return Optional.empty();
        }

        private String getMeasurementName(String operationName, Version version) {
            if (version == null) {
                return String.format("%s/%s", WebSocketHttpOperationServiceBean.this.context, operationName);
            }
            return String.format("%s/%s/%s", WebSocketHttpOperationServiceBean.this.context, operationName, version);
        }
    }

    private static abstract class NotFound
    implements BaseWebSocketOperation<WebSocketOperationSessionData> {
        private NotFound() {
        }

        @Override
        public void onSessionOpen(WebSocketOperationSessionData sessionData, WebSocketMessagingChannel channel) {
        }

        @Override
        public void onSessionClose(WebSocketOperationSessionData sessionData) {
        }

        @Override
        public void onMessage(WebSocketOperationSessionData sessionData, WebSocketMessagingChannel channel, WebSocketMessage message) {
        }

        @Override
        @Nonnull
        public SessionType getSessionType() {
            return SessionType.REQUIRES_SESSION;
        }

        @Override
        public WebSocketSubProtocol getSubProtocol() {
            return WebSocketSubProtocol.NONE;
        }
    }
}

