/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.http.HttpOperationContainer;
import com.ericsson.lwac.http.HttpOperationService;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class HttpOperationContainerBean
implements HttpOperationContainer {
    private List<String> operationClasses = new ArrayList<String>();
    private List<String> optionalOperationClasses = Collections.emptyList();
    private String[] operationServices;
    private static final Logger logger = LoggerFactory.getLogger(HttpOperationContainerBean.class);
    private Context context;

    @Override
    public List<String> getOperationClasses() {
        return ImmutableList.copyOf(this.operationClasses);
    }

    public void setOperationClasses(List<String> operationClasses) {
        this.operationClasses = new ArrayList<String>(operationClasses);
    }

    public void setOptionalOperationClasses(List<String> optionalOperationClasses) {
        this.optionalOperationClasses = new ArrayList<String>(optionalOperationClasses);
    }

    public void setOperationServices(String operationServices) {
        this.operationServices = operationServices.split(",");
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.registerOperationContainers();
        this.evaluateOptionalOperations();
    }

    private void registerOperationContainers() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        for (String operationServiceName : this.operationServices) {
            HttpOperationService operationService = (HttpOperationService)this.context.lookup(operationServiceName);
            operationService.registerOperationContainer(this);
        }
    }

    private void evaluateOptionalOperations() {
        for (String operation : this.optionalOperationClasses) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(operation);
                this.operationClasses.add(operation);
            }
            catch (ClassNotFoundException e) {
                logger.debug("Ignoring optional operation {}", (Object)operation);
            }
        }
    }
}

