/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.feature;

import com.ericsson.lwac.feature.Feature;
import com.ericsson.lwac.feature.PermissionBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class FeatureDefinition
implements Feature {
    private final String name;
    private final Map<String, String[]> groupedPermissions;
    private final boolean defaultActive;

    public FeatureDefinition(String name, boolean defaultActive) {
        this.name = name;
        this.groupedPermissions = this.permissions().toMap();
        this.defaultActive = defaultActive;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract PermissionBuilder permissions();

    public final Set<String> getPermissions() {
        HashSet<String> result = new HashSet<String>();
        for (String[] bucket : this.groupedPermissions.values()) {
            result.addAll(Arrays.asList(bucket));
        }
        return Collections.unmodifiableSet(result);
    }

    public final Set<String> getPermissions(String group) {
        String[] permissions = this.groupedPermissions.get(group);
        if (permissions == null) {
            return null;
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(permissions)));
    }

    public final Set<String> getPermissionGroups() {
        return Collections.unmodifiableSet(this.groupedPermissions.keySet());
    }

    public boolean isDefaultActive() {
        return this.defaultActive;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureDefinition other = (FeatureDefinition)obj;
        return this.name.equals(other.name);
    }
}

