/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.actions;

import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);

    private ExceptionHandler() {
    }

    public static <T, U> BiFunction<? super T, Throwable, ? extends U> newExceptionHandler(BiFunction<? super T, RuntimeException, ? extends U> fn) {
        return (t, throwable) -> {
            Throwable child = throwable;
            if (throwable != null) {
                while (child instanceof CompletionException) {
                    child = child.getCause();
                }
                if (!(child instanceof RuntimeException)) {
                    logger.error("Non runtime exception found", (Throwable)throwable);
                    throw new AssertionError("Non runtime exception found", (Throwable)throwable);
                }
            }
            return fn.apply(t, (RuntimeException)child);
        };
    }
}

