/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.util.ArrayList;

public class JavaVersionChecker {
    public static boolean isVersionCompatible(String requiredVersionString) {
        String currentVersionString = System.getProperty("java.version");
        JavaVersion requiredVersion = new JavaVersion(requiredVersionString);
        JavaVersion currentVersion = new JavaVersion(currentVersionString);
        if (requiredVersion.isValid() && currentVersion.isValid()) {
            return currentVersion.compareTo(requiredVersion) >= 0;
        }
        return true;
    }

    static class JavaVersion
    implements Comparable<JavaVersion> {
        private ArrayList<Integer> myVersion;
        private String myPrereleaseString;
        private boolean myIsValid = true;

        JavaVersion(String version) {
            String[] possiblePreelease = version.split("-");
            String local = version;
            if (possiblePreelease.length > 1) {
                local = possiblePreelease[0];
                this.myPrereleaseString = possiblePreelease[1];
            }
            String[] versionArr = local.split("[\\._]");
            this.myVersion = new ArrayList();
            for (String versionToken : versionArr) {
                try {
                    this.myVersion.add(Integer.parseInt(versionToken));
                }
                catch (NumberFormatException nfe) {
                    this.myIsValid = false;
                    break;
                }
            }
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @Override
        public int compareTo(JavaVersion otherVersion) {
            int returnValue = 0;
            int myVersionSize = this.myVersion.size();
            int OtherVersionSize = otherVersion.myVersion.size();
            for (int i = 0; i < myVersionSize && i < OtherVersionSize; ++i) {
                if (this.myVersion.get(i) == otherVersion.myVersion.get(i)) continue;
                returnValue = this.myVersion.get(i) - otherVersion.myVersion.get(i);
                break;
            }
            if (returnValue == 0) {
                returnValue = myVersionSize == OtherVersionSize ? (this.myPrereleaseString == null && otherVersion.myPrereleaseString == null ? 0 : (this.myPrereleaseString == null ? 1 : (otherVersion.myPrereleaseString == null ? -1 : 0))) : myVersionSize - OtherVersionSize;
            }
            return returnValue;
        }
    }
}

