/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class WrappingLabel
extends JPanel {
    private static final long serialVersionUID = 1L;
    AttributedString myAttributedString;
    private int myPrefHeight = -1;
    private String myText;
    private int myHorizAlign;
    private boolean myFontHasBeenSet = false;
    private boolean myUseAntiAliasing = true;

    public WrappingLabel(String text, int horizAlign) {
        super(true);
        if (text == null) {
            throw new IllegalArgumentException("Null text not allowed.");
        }
        this.setHorizontal(horizAlign);
        this.myAttributedString = this.createString(text);
        this.myText = text;
    }

    public WrappingLabel(String text) {
        this(text, 2);
    }

    private void setHorizontal(int key) {
        if (key == 2 || key == 0 || key == 4 || key == 10 || key == 11) {
            this.myHorizAlign = key == 10 ? 2 : (key == 11 ? 4 : key);
        } else {
            throw new IllegalArgumentException("Invalid horizontal alignment.");
        }
    }

    private AttributedString createString(String text) {
        Font font = this.myFontHasBeenSet ? this.getFont() : (Font)UIManager.get("Label.font");
        AttributedString as = new AttributedString(text.length() > 0 ? text : " ");
        as.addAttribute(TextAttribute.FONT, font);
        as.addAttribute(TextAttribute.FOREGROUND, this.getForeground());
        return as;
    }

    public void setHorizontalAlignment(int horizAlign) {
        if (horizAlign != this.myHorizAlign) {
            this.setHorizontal(horizAlign);
            this.invalidate();
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null text not allowed.");
        }
        if (!this.myText.equals(text)) {
            this.myText = text;
            this.myAttributedString = this.createString(text);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setForeground(Color col) {
        if (this.myAttributedString != null) {
            this.myAttributedString.addAttribute(TextAttribute.FOREGROUND, col);
        }
        super.setForeground(col);
    }

    @Override
    public void setFont(Font font) {
        if (this.myAttributedString != null) {
            this.myAttributedString.addAttribute(TextAttribute.FONT, font);
        }
        this.myFontHasBeenSet = true;
        super.setFont(font);
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.myPrefHeight > 0) {
            d = new Dimension(d.width, this.myPrefHeight);
        }
        return d;
    }

    public void disableAntiAliasing() {
        this.myUseAntiAliasing = false;
    }

    @Override
    public void paint(Graphics g) {
        boolean needInvalidate;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.myUseAntiAliasing) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Insets insets = this.getInsets();
        int width = this.getSize().width - insets.right - insets.left;
        int x = insets.left;
        int y = insets.top;
        AttributedCharacterIterator characterIterator = this.myAttributedString.getIterator();
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, fontRenderContext);
        while (measurer.getPosition() < characterIterator.getEndIndex()) {
            TextLayout textLayout = measurer.nextLayout(width);
            y = (int)((float)y + textLayout.getAscent());
            int drawx = this.myHorizAlign == 4 ? x + width - (int)textLayout.getAdvance() : (this.myHorizAlign == 0 ? x + (width - (int)textLayout.getAdvance()) / 2 : x);
            textLayout.draw(g2d, drawx, y);
            y = (int)((float)y + (textLayout.getDescent() + textLayout.getLeading()));
        }
        int oldPrefHeight = this.myPrefHeight;
        this.myPrefHeight = y + insets.bottom;
        boolean bl = needInvalidate = oldPrefHeight < 0 || oldPrefHeight != this.myPrefHeight;
        if (needInvalidate) {
            this.revalidate();
            this.repaint();
        }
    }
}

