/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.util.Predicate;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CollectingTariffStructureVisitor
implements TariffStructureVisitor {
    private List<TariffStructureNode> myCollected = new LinkedList<TariffStructureNode>();
    private Predicate<TariffStructureNode> myPredicate;
    private TariffStructureNode myCurrentLink;

    public CollectingTariffStructureVisitor(Predicate<TariffStructureNode> pred) {
        this.myPredicate = pred;
    }

    public List<TariffStructureNode> getCollectedElements() {
        return Collections.unmodifiableList(this.myCollected);
    }

    @Override
    public void enterCondition(TariffStructureNode n) throws Exception {
        this.updateCurrentLink(n);
        this.collectIfMatch(n);
    }

    @Override
    public void enterModifier(TariffStructureNode n) throws Exception {
        this.updateCurrentLink(n);
        this.collectIfMatch(n);
    }

    @Override
    public void enterNode(TariffStructureNode n) throws Exception {
        this.updateCurrentLink(n);
        this.collectIfMatch(n);
    }

    @Override
    public void enterTariffStructure(TariffStructureNode n) throws Exception {
        this.updateCurrentLink(n);
        this.collectIfMatch(n);
    }

    private void updateCurrentLink(TariffStructureNode n) {
        if (this.myCurrentLink == null && n.isLink()) {
            this.myCurrentLink = n;
        }
    }

    private void collectIfMatch(TariffStructureNode n) {
        if (this.myPredicate.test(n) && !n.isLink() && this.myCurrentLink == null) {
            this.myCollected.add(n);
        }
    }

    @Override
    public void leaveCondition(TariffStructureNode n) throws Exception {
        this.resetCurrentLink(n);
    }

    @Override
    public void leaveModifier(TariffStructureNode n) throws Exception {
        this.resetCurrentLink(n);
    }

    @Override
    public void leaveNode(TariffStructureNode n) throws Exception {
        this.resetCurrentLink(n);
    }

    @Override
    public void leaveTariffStructure(TariffStructureNode n) throws Exception {
        this.resetCurrentLink(n);
    }

    private void resetCurrentLink(TariffStructureNode n) {
        if (this.myCurrentLink == n) {
            this.myCurrentLink = null;
        }
    }
}

