/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.DefaultHierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AvailableFieldListBuilder {
    private ClassRepository myRepository;
    private boolean myAllowHFs = false;
    private boolean myAllowSetSubfields = false;
    private List<HierarchicalFieldFilter> myHierarchicalFilterList;
    private List<FieldFilter> myFilterList;
    private ClassProfile myProfile;
    private Constrainable myConstrainable;
    private ConstraintContext myConstraintContext;
    private HierarchicalFieldFilter myContextFilter;

    protected AvailableFieldListBuilder(ClassRepository repository) {
        this.myRepository = repository;
        this.myHierarchicalFilterList = new ArrayList<HierarchicalFieldFilter>();
        this.myFilterList = new ArrayList<FieldFilter>();
    }

    public ClassRepository getClassRepository() {
        return this.myRepository;
    }

    public static AvailableFieldListBuilder createAvailableFieldListBuilder(ClassRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository argument must not be null.");
        }
        return new AvailableFieldListBuilder(repository);
    }

    public AvailableFieldListBuilder withHierarchicalFields() {
        this.myAllowHFs = true;
        return this;
    }

    public AvailableFieldListBuilder withSetSubFields() {
        this.myAllowSetSubfields = true;
        return this;
    }

    public AvailableFieldListBuilder withFilter(HierarchicalFieldFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter argument must not be null.");
        }
        this.myHierarchicalFilterList.add(filter);
        return this;
    }

    public AvailableFieldListBuilder withFilter(FieldFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter argument must not be null.");
        }
        this.myFilterList.add(filter);
        return this;
    }

    public AvailableFieldListBuilder withContext(String context) {
        if (StringUtil.isEmptyString(context)) {
            throw new IllegalArgumentException("context argument must not be null or empty.");
        }
        this.checkIfContextFilterSet();
        if (!"ALL fields".equals(context)) {
            this.myContextFilter = "Non context field".equals(context) ? new NonContextFieldFilter() : new ContextFieldFilter(context);
        }
        return this;
    }

    public AvailableFieldListBuilder withConstraints(ClassProfile profile, ConstraintContext context) {
        if (profile == null) {
            throw new IllegalArgumentException("Profile argument must not be null.");
        }
        this.checkIfConstraintsSet();
        this.myProfile = profile;
        this.myConstraintContext = context != null ? context : new ConstraintContext.Builder().build();
        return this;
    }

    public AvailableFieldListBuilder withConstraints(Constrainable constrainable, ConstraintContext context) {
        if (constrainable == null) {
            throw new IllegalArgumentException("Constrainable argument must not be null.");
        }
        this.checkIfConstraintsSet();
        this.myConstrainable = constrainable;
        this.myConstraintContext = context != null ? context : new ConstraintContext.Builder().build();
        return this;
    }

    public List<FieldHierarchyNode> buildList() {
        FieldRepository fieldRepo = this.myRepository.getFieldRepository();
        List<FieldHierarchyNode> fieldList = this.myAllowHFs ? fieldRepo.getAllFields() : fieldRepo.getTopLevelFields();
        return this.buildWithStartingList(fieldList);
    }

    public boolean filtersAllow(FieldHierarchyNode field) {
        return field != null && this.buildWithStartingList(Arrays.asList(field)).size() > 0;
    }

    private List<FieldHierarchyNode> buildWithStartingList(List<FieldHierarchyNode> startList) {
        List<FieldHierarchyNode> fieldList = startList;
        if (this.myProfile != null) {
            fieldList = ConstraintService.constrainFieldDefinitions(this.myProfile, this.myConstraintContext, this.myRepository, fieldList);
        } else if (this.myConstrainable != null) {
            fieldList = ConstraintService.constrainFieldDefinitions(this.myConstrainable, this.myConstraintContext, this.myRepository, fieldList);
        }
        this.myHierarchicalFilterList.add(new UnmappedContextFieldFilter(this.myRepository));
        this.myHierarchicalFilterList.add(new DefaultHierarchicalFieldFilter(new ClassRepositoryHelper.VisibleFieldFilter(this.myRepository), this.myAllowHFs));
        for (FieldFilter filter : this.myFilterList) {
            this.myHierarchicalFilterList.add(new DefaultHierarchicalFieldFilter(filter, this.myAllowHFs));
        }
        if (this.myContextFilter != null) {
            this.myHierarchicalFilterList.add(this.myContextFilter);
        }
        if (!this.myAllowSetSubfields) {
            this.myHierarchicalFilterList.add(new SetSubFieldFilter());
        }
        fieldList = FieldOrientedPluginProfileUtil.getSupportedFields(fieldList, this.myHierarchicalFilterList.toArray(new HierarchicalFieldFilter[0]));
        return fieldList;
    }

    public List<FieldDefinition> buildFieldDefinitionList() {
        ArrayList<FieldDefinition> fdList = new ArrayList<FieldDefinition>();
        for (FieldHierarchyNode node : this.buildList()) {
            if (!node.isLeaf()) continue;
            fdList.add((FieldDefinition)node);
        }
        return fdList;
    }

    public List<String> buildFieldNameList() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldHierarchyNode field : this.buildList()) {
            fieldNames.add(field.getCanonicalName());
        }
        return fieldNames;
    }

    private void checkIfConstraintsSet() {
        if (this.myProfile != null || this.myConstrainable != null) {
            throw new IllegalStateException("Not allowed to run \"withConstraints\"-method more than once.");
        }
    }

    private void checkIfContextFilterSet() {
        if (this.myContextFilter != null) {
            throw new IllegalStateException("Not allowed to run \"withContext\"-method more than once.");
        }
    }

    private class UnmappedContextFieldFilter
    implements HierarchicalFieldFilter {
        private final ClassRepository myRepository;

        private UnmappedContextFieldFilter(ClassRepository repository) {
            this.myRepository = repository;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return this.fieldIsContextIdentifier(field, this.myRepository) || !this.fieldIsUnmappedContextfield(field);
        }

        private boolean fieldIsContextIdentifier(FieldHierarchyNode field, ClassRepository repository) {
            return field.getFieldName().equals(repository.getContextFieldIdentifier());
        }

        private boolean fieldIsUnmappedContextfield(FieldHierarchyNode field) {
            return field.isContextField() && field.getContextNames().isEmpty();
        }
    }

    private class SetSubFieldFilter
    implements HierarchicalFieldFilter {
        private SetSubFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return !this.isSetDescendant(field);
        }

        private boolean isSetDescendant(FieldHierarchyNode field) {
            boolean isSetDescendant = false;
            for (FieldStructure currentField = field.getParent(); currentField != null; currentField = currentField.getParent()) {
                if (currentField.getComplexType() != FieldHierarchyNode.ComplexType.SET) continue;
                isSetDescendant = true;
                break;
            }
            return isSetDescendant;
        }
    }

    private class ContextFieldFilter
    implements HierarchicalFieldFilter {
        private String myContext;

        ContextFieldFilter(String context) {
            this.myContext = context;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return field.getContextNames().contains(this.myContext);
        }
    }

    private class NonContextFieldFilter
    implements HierarchicalFieldFilter {
        private NonContextFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return field.getContextNames().isEmpty();
        }
    }
}

