/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures.treedefinedfields;

import com.ericsson.ere.datatype.ERETimeFactory;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.defs.EreDefs;
import java.math.BigInteger;
import java.util.Date;

public class TreeDefinedFieldAdditionalVar {
    private String myName;
    private String myDataType;
    private int myIntdataType;
    private String myValue;

    public TreeDefinedFieldAdditionalVar(String name, String datatype, String value) {
        this.myName = name;
        this.myDataType = datatype;
        this.myIntdataType = EreDefs.getDataType(this.myDataType);
        this.myValue = value;
    }

    public String getName() {
        return this.myName;
    }

    public String getDataType() {
        return this.myDataType;
    }

    public String getValue() {
        return this.myValue;
    }

    public Object createValueObject() {
        return TreeDefinedFieldAdditionalVar.createValueFromString(this.myIntdataType, this.myValue);
    }

    private static Object createValueFromString(int dataType, String valueStr) {
        switch (dataType) {
            case 0: {
                return UnsignedInt32.valueOf(valueStr);
            }
            case 1: {
                return UnsignedInt16.valueOf(valueStr);
            }
            case 2: {
                return UnsignedInt8.valueOf(valueStr);
            }
            case 3: {
                return new MonetaryUnits(valueStr);
            }
            case 4: {
                return new Decimal(valueStr);
            }
            case 5: {
                return ERETimeFactory.parseTimeString(valueStr);
            }
            case 6: {
                return valueStr;
            }
            case 7: {
                return new BcdString(valueStr);
            }
            case 8: {
                return new OctetString(valueStr);
            }
            case 9: {
                return Short.valueOf(valueStr);
            }
            case 10: {
                return Integer.valueOf(valueStr);
            }
            case 11: {
                return Long.valueOf(valueStr);
            }
            case 12: {
                return Double.valueOf(valueStr);
            }
            case 13: {
                return Boolean.valueOf(valueStr);
            }
            case 14: {
                return new Date(Long.valueOf(valueStr));
            }
            case 15: {
                BigInteger bigInt = new BigInteger(valueStr);
                return bigInt.shortValue();
            }
            case 16: {
                BigInteger bigInt2 = new BigInteger(valueStr);
                return bigInt2.intValue();
            }
            case 17: {
                BigInteger bigInt3 = new BigInteger(valueStr);
                return bigInt3.longValue();
            }
        }
        return null;
    }
}

