/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.structures;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.selectiontree.statements.NodeStatement;
import com.ericsson.ere.selectiontree.structures.ImmutablePeriodTreeDescription;
import com.ericsson.ere.selectiontree.structures.PeriodTreeDescription;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldBuilderFactory;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TreeDefinedFieldDefaultBuilderFactory;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import ericsson.ere.RatingData;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public abstract class ImmutableTariffStructure
extends AbstractDAGNode
implements TariffStructureNode,
com.ericsson.ere.selectiontree.interfaces.TariffStructure,
TariffStructure,
UsedFieldLister {
    protected final String myName;
    protected final String myNodeId;
    protected final TreeDefinedFieldBuilderFactory myTDFBuilderFactory;
    protected final ImmutablePeriodTreeDescription myPeriodTreeDescription;
    private ExecutableNode myStatement;
    private final ClassRepository myRepository;

    protected ImmutableTariffStructure(ParseContext ctx, TariffStructureNode[] children) {
        this(ctx, children, false);
    }

    protected ImmutableTariffStructure(ParseContext ctx, TariffStructureNode[] children, boolean useTDF) {
        Element versionElement;
        if (ctx == null) {
            throw new IllegalArgumentException("Immutable Tariff Structure cannot be created without a context.");
        }
        this.myRepository = ctx.getClassRepository();
        Node nodeConfig = ctx.getXMLNode();
        NamedNodeMap attr = nodeConfig.getAttributes();
        if (attr == null) {
            throw new PluginCreationException("Attributes not found in TariffStructure", nodeConfig);
        }
        Node node = attr.getNamedItem("id");
        if (node == null) {
            node = attr.getNamedItem("Id");
        }
        this.myNodeId = node != null ? node.getNodeValue() : null;
        node = attr.getNamedItem("Name");
        if (node == null) {
            throw new PluginCreationException(EreDefs.getErrorString("error.noNameAttrInTariff"), nodeConfig);
        }
        this.myName = node.getNodeValue();
        node = attr.getNamedItem("ServiceId");
        if (node == null) {
            throw new PluginCreationException(EreDefs.getErrorString("error.noServiceAttrInTariff"), nodeConfig);
        }
        String serviceIdString = node.getNodeValue();
        node = attr.getNamedItem("TariffType");
        String tariffTypeStr = node != null ? node.getNodeValue() : null;
        Element versionNode = XMLUtil.getNamedElement("Version", nodeConfig.getChildNodes());
        ImmutablePeriodTreeDescription.ImmutablePeriodTreeVersion ptv = null;
        if (versionNode != null && (versionElement = versionNode).hasAttribute("id") && versionElement.hasAttribute("version") && versionElement.hasAttribute("created") && versionElement.hasAttribute("modified")) {
            String idStr = versionElement.getAttribute("id");
            Long version = null;
            try {
                version = Long.parseLong(versionElement.getAttribute("version"));
            }
            catch (NumberFormatException nfe) {
                throw new PluginCreationException("Could not extract version number", (Node)versionElement);
            }
            String createDate = versionElement.getAttribute("created");
            String modifiedDate = versionElement.getAttribute("modified");
            ptv = ImmutablePeriodTreeDescription.createTariffVersion(idStr, version, createDate, modifiedDate);
        }
        this.myPeriodTreeDescription = new ImmutablePeriodTreeDescription(this.myName, this.myNodeId, serviceIdString, tariffTypeStr, ptv);
        if (useTDF) {
            Element fieldsElement = XMLUtil.getNamedElement("Fields", nodeConfig.getChildNodes());
            this.myTDFBuilderFactory = this.createTreeDefinedFieldFactory();
            this.myTDFBuilderFactory.init(fieldsElement, this.myRepository);
        } else {
            this.myTDFBuilderFactory = null;
        }
        this.myStatement = this.createStatement(ctx, children, this.myName, this.myNodeId);
    }

    private ExecutableNode createStatement(ParseContext ctx, TariffStructureNode[] children, String name, String id) {
        try {
            String idStr = id == null ? "" : " id='" + id + "'";
            String xml = String.format("<Node%s>%s</Node>", idStr, name);
            Element config = XMLUtil.buildDocumentFromString(xml).getDocumentElement();
            SelectionTreeNodeFactoryImpl factory = new SelectionTreeNodeFactoryImpl(ctx.getClassRepository(), ctx.getRatingPlanName());
            TariffStructureNode node = factory.createNode(config, children);
            if (node instanceof AbstractNodeStatement) {
                ((AbstractNodeStatement)node).buildFinished();
            }
            return (ExecutableNode)((Object)node);
        }
        catch (Exception e) {
            throw new PluginCreationException("Failed to create internal node.", e);
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public final DAGNode getChildAt(int i) {
        return ((DAGNode)((Object)this.myStatement)).getChildAt(i);
    }

    @Override
    public final int getChildCount() {
        return ((DAGNode)((Object)this.myStatement)).getChildCount();
    }

    @Override
    public final void insertChildAt(int i, DAGNode n) {
        throw new UnsupportedOperationException("Immutable structure, cannot add child.");
    }

    @Override
    public final void insertLinkAt(int i, DAGNode n) {
        throw new UnsupportedOperationException("Immutable structure, cannot add link.");
    }

    @Override
    public final void replace(DAGNode child, DAGNode replacement) {
        ((DAGNode)((Object)this.myStatement)).replace(child, replacement);
        if (this.myStatement instanceof NodeStatement) {
            ((NodeStatement)this.myStatement).buildFinished();
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    protected final void removeLink(DAGNode node) {
        throw new UnsupportedOperationException("Link not removed, structure is read-only");
    }

    @Override
    protected final void removeChild(DAGNode node) {
        throw new UnsupportedOperationException("Child not removed, structure is read-only");
    }

    public String toString() {
        return this.myName;
    }

    @Override
    public final boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterTariffStructure(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveTariffStructure(this);
    }

    @Override
    public String getNodeId() {
        return this.myStatement.getNodeId();
    }

    public void createTDFFields(DataSet theData) {
        if (this.myTDFBuilderFactory != null) {
            this.myTDFBuilderFactory.createTreeDefinedField(theData);
        }
    }

    public void registerPeriodTreeDescription(DataSet theData) {
        theData.addPeriodTreeDescritpion(new PeriodTreeDescription(this.myPeriodTreeDescription));
    }

    @Override
    public final int getNodeType() {
        return 0;
    }

    protected String checkGetParam(String name, NodeList children, boolean mandatory) throws IllegalArgumentException {
        String text = null;
        Element node = XMLUtil.getNamedElement(name, children);
        if (node != null) {
            text = XMLUtil.getFirstTextContent(node);
        } else if (mandatory) {
            throw new IllegalArgumentException("Missing element: " + name);
        }
        return text;
    }

    protected TreeDefinedFieldBuilderFactory createTreeDefinedFieldFactory() {
        return new TreeDefinedFieldDefaultBuilderFactory();
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.myRepository;
    }

    @Override
    public void execute(DataSet theData) {
        this.executeUsingExecutor(theData);
    }

    @Override
    public final void add(Statement child) throws Exception {
        throw new UnsupportedOperationException("Immutable structure, cannot add child.");
    }

    @Override
    public final void rate(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        throw new UnsupportedOperationException("Method not supported for this kind of structure.");
    }

    @Override
    public final void setClassRepository(ClassRepository rep) {
        throw new UnsupportedOperationException("Immutable structure, cannot set class repository.");
    }

    @Override
    public final XMLInitializable init(Node iterator) throws Exception {
        throw new UnsupportedOperationException("Immutable class cannot be initialized.");
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        ImmutableTariffStructure clone = (ImmutableTariffStructure)this.clone();
        TraceNodeTariffStructure ts = new TraceNodeTariffStructure(clone);
        clone.myStatement = (ExecutableNode)((Object)this.myStatement.createTraceNode(0, ts));
        return ts;
    }

    protected final void executeUsingExecutor(DataSet dataSet) {
        TreeExecutorHelper.executeExecutableNode(this.myStatement, dataSet);
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myTDFBuilderFactory == null ? 0 : this.myTDFBuilderFactory.hashCode());
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        result = 31 * result + (this.myPeriodTreeDescription == null ? 0 : this.myPeriodTreeDescription.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        result = 31 * result + (this.myStatement == null ? 0 : this.myStatement.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableTariffStructure other = (ImmutableTariffStructure)obj;
        if (this.myTDFBuilderFactory == null ? other.myTDFBuilderFactory != null : !this.myTDFBuilderFactory.equals(other.myTDFBuilderFactory)) {
            return false;
        }
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        if (this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId)) {
            return false;
        }
        if (this.myPeriodTreeDescription == null ? other.myPeriodTreeDescription != null : !this.myPeriodTreeDescription.equals(other.myPeriodTreeDescription)) {
            return false;
        }
        if (this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository)) {
            return false;
        }
        return !(this.myStatement == null ? other.myStatement != null : !this.myStatement.equals(other.myStatement));
    }

    @Override
    public Set<String> getUsedFields() {
        return new HashSet<String>();
    }
}

