/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.trace.TraceNodeInterface;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StatementLink
extends Statement
implements TariffNodeLink {
    protected String myTargetName = null;
    protected ExecutableNode myTargetNode = null;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = iterator.getAttributes();
        if (attr == null) {
            throw new IllegalArgumentException("No attributes found for node: " + this.getName());
        }
        this.myTargetName = attr.getNamedItem("target").getNodeValue().trim();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myTargetName == null ? 0 : this.myTargetName.hashCode());
        result = 31 * result + (this.myTargetNode == null ? 0 : this.myTargetNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementLink other = (StatementLink)obj;
        if (this.myTargetName == null ? other.myTargetName != null : !this.myTargetName.equals(other.myTargetName)) {
            return false;
        }
        return !(this.myTargetNode == null ? other.myTargetNode != null : !this.myTargetNode.equals(other.myTargetNode));
    }

    @Override
    public void execute(DataSet theData) {
        this.myTargetNode.execute(theData);
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return (DAGNode)((Object)this.myTargetNode);
        }
        throw new IndexOutOfBoundsException("No child at index: " + index);
    }

    @Override
    public int getChildCount() {
        if (this.myTargetNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (ExecutableNode)((Object)node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (ExecutableNode)((Object)node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        if (child != this.myTargetNode) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myTargetNode = (ExecutableNode)((Object)replacement);
    }

    @Override
    public void add(XMLInitializable node) throws IndexOutOfBoundsException {
        this.insertChildAt(this.getChildCount(), (DAGNode)((Object)node));
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.getLinkPath();
        }
        id = id.replace('/', '\\');
        return id;
    }

    @Override
    public String getLinkPath() {
        return this.myTargetName;
    }

    @Override
    public void setTarget(TariffStructureNode node) throws IllegalArgumentException, Exception {
        if (node == null) {
            throw new IllegalArgumentException("null target not allowed");
        }
        if (this.getChildCount() > 0) {
            if (node != this.getChildAt(0)) {
                throw new IllegalArgumentException("Link already contains child");
            }
        } else {
            this.insertLinkAt(0, node);
        }
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            StatementLink clone = (StatementLink)this.clone();
            clone.myTargetNode = null;
            clone.insertLinkAt(0, this.myTargetNode.createTraceNode(childIndex, parent));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    public String toString() {
        return this.myTargetName + " -> " + (this.myTargetNode == null ? " null" : this.myTargetNode.toString());
    }
}

