/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.defs.ProfileAlreadyRegisteredSTQException;
import com.ericsson.ere.defs.STQRepositories;
import com.ericsson.ere.defs.STQRepository;
import com.ericsson.ere.interfaces.DynamicClassProfile;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatementProfile;
import com.ericsson.ere.selectiontree.statements.NodeStatementProfileContract;
import com.ericsson.ere.selectiontree.statements.STQChangeEvent;
import com.ericsson.ere.selectiontree.statements.STQNotificationReceiver;
import com.ericsson.ere.swing.IconIndicableTextField;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfileV2;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.RegularExpressionMatcherDocument;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.IconIndicationType;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.WatermarkStringVariable;
import java.awt.Component;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Constrainable(contractClass=NodeStatementProfileContract.class)
public class NodeStatementProfile
extends AbstractNodeStatementProfile
implements ClassProfileV2,
DynamicClassProfile,
STQNotificationReceiver {
    private static final String STQ_FEATURE = "STQ_Support";
    private static final String STQ_DISPLAYSTRING = "Enter a qualifier";
    private static final String STQ_VALUE_RECYCLE_TOOLIP = "This qualifier is used elsewhere in the tree.";
    public static final String LBL_ID = "Id";
    public static final String LBL_NAME = "Name";
    public static final String LBL_COMMENT = "Comment";
    public static final String LBL_INVERTED = "Inverted";
    public static final String LBL_STQ = "Qualifier";
    private boolean myUseSTQBehavior = false;
    private STQRepository mySTQRepository;
    private String myCachedSTQValue = null;
    private boolean myUpdateSTQStatus;

    public NodeStatementProfile() {
    }

    protected NodeStatementProfile(boolean enableSTQ) {
        this.myUseSTQBehavior = enableSTQ;
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(STQ_FEATURE);
    }

    @Override
    public void setTariffStructureNode(DAGNode node) {
        super.setTariffStructureNode(node);
        if (this.myUseSTQBehavior) {
            TariffDAGModel model = ((TariffDAGNode)node).getTreeModel();
            this.mySTQRepository = STQRepositories.getRepositoryForTreeModel(model);
        }
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        if (!this.myUseSTQBehavior) {
            List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, NodeStatementProfile.getSupportedFeatures());
            this.myUseSTQBehavior = enabledFeatures.contains(STQ_FEATURE);
        }
    }

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(false, null);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        boolean callNextWhenFalse = Boolean.parseBoolean(XMLUtil.getAttributeFromElement((Element)iterator, "CallNextWhenFalse", Boolean.toString(false)));
        String stqValue = XMLUtil.getAttributeFromElement((Element)iterator, "STQvalue", null);
        return this.getVariables(callNextWhenFalse, stqValue);
    }

    private List<Variable> getVariables(boolean inverted, String stqValue) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        BoolVariable boolVar = new BoolVariable(LBL_INVERTED, inverted);
        l.add(boolVar);
        if (this.myUseSTQBehavior) {
            Variable stqVariable = this.createSTQVariable(stqValue);
            l.add(stqVariable);
        }
        return l;
    }

    private Variable createSTQVariable(String stqValue) {
        STQVariable stqVariable;
        this.unregisterSTQ(this.myCachedSTQValue);
        if (stqValue == null) {
            stqVariable = new STQVariable();
        } else {
            stqVariable = new STQVariable(stqValue);
            this.registerSTQ(stqValue);
            stqVariable.updateSTQIndicationState();
            this.myCachedSTQValue = stqValue;
        }
        return stqVariable;
    }

    private void registerSTQ(String stqValue) {
        block3: {
            if (stqValue != null) {
                SelectionTreeQualifier stq = SelectionTreeQualifier.valueOf(stqValue);
                try {
                    this.mySTQRepository.registerSTQReference(stq, this);
                }
                catch (ProfileAlreadyRegisteredSTQException ignore) {
                    if ($assertionsDisabled || ignore.getQualifier().equals(stq)) break block3;
                    throw new AssertionError((Object)String.format("Attempting to register STQ %s but had previously registered STQ %s.", stq, ignore.getQualifier()));
                }
            }
        }
    }

    private void unregisterSTQ(String stqValue) {
        if (stqValue != null) {
            SelectionTreeQualifier stq = SelectionTreeQualifier.valueOf(stqValue);
            this.mySTQRepository.unregisterSTQReference(stq, this);
        }
    }

    private Document createSTQDocument(String displayString) {
        String regExp = "[\\d]+|" + Pattern.quote(displayString) + "|";
        return new RegularExpressionMatcherDocument(regExp, new BigInteger("0"), new BigInteger("4294967295"));
    }

    @Override
    public void printAdditionalPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        super.printAdditionalPreamble(out, indentLevel, indentMarker, variables);
        Boolean cnwf = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        if (cnwf != null && cnwf.booleanValue()) {
            out.print(XMLUtil.wrapInAttribute("CallNextWhenFalse", cnwf.toString()));
        }
        String stqValue = VarListUtil.getValueStringForName(variables, LBL_STQ);
        if (this.myUseSTQBehavior) {
            out.print(XMLUtil.wrapInAttribute("STQvalue", stqValue));
        }
    }

    @Override
    public String getDescription(List<Variable> variables) {
        if (variables == null) {
            return "";
        }
        String resultString = this.createNameString(false, variables);
        String descriptionString = this.createAdditionalString(false, variables);
        String extendedDescriptionString = this.getExtendedDescription(variables);
        descriptionString = descriptionString + (descriptionString.equals("") || extendedDescriptionString.equals("") ? "" : ", ");
        descriptionString = descriptionString + extendedDescriptionString;
        resultString = resultString + (descriptionString.equals("") ? "" : " (" + descriptionString);
        resultString = resultString + (descriptionString.equals("") ? "" : ")");
        return resultString;
    }

    protected String getExtendedDescription(List<Variable> variables) {
        return "";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String extendedAdditionalInfoString;
        String resultString = this.createNameString(true, variables) + " ";
        String additionalInfoString = extendedAdditionalInfoString = this.getExtendedAdditionalInfo(variables);
        additionalInfoString = additionalInfoString + (extendedAdditionalInfoString.equals("") ? "" : ", ");
        additionalInfoString = additionalInfoString + this.createAdditionalString(true, variables);
        resultString = resultString + (additionalInfoString.equals("") ? "" : "(");
        resultString = resultString + additionalInfoString;
        resultString = resultString + (additionalInfoString.equals("") ? "" : ")");
        String comment = VarListUtil.getValueStringForName(variables, LBL_COMMENT);
        if (comment != null && !"".equals(comment)) {
            resultString = resultString + "<p>" + GuiUtil.replaceSubString(comment, "\n", "<p>");
        }
        resultString = resultString + "</html>";
        return resultString;
    }

    protected String getExtendedAdditionalInfo(List<Variable> variables) {
        return "";
    }

    private String createNameString(boolean additionalFormatDescription, List<Variable> variables) {
        StringBuilder builder = new StringBuilder();
        if (additionalFormatDescription) {
            builder.append("<html><b>");
        }
        builder.append(VarListUtil.getValueForName(variables, LBL_NAME));
        if (additionalFormatDescription) {
            builder.append("</b>");
        }
        return builder.toString();
    }

    private String createAdditionalString(boolean additionalFormatDescription, List<Variable> variables) {
        StringBuilder builder = new StringBuilder();
        Boolean invertedExecution = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        String stqValueString = VarListUtil.getValueStringForName(variables, LBL_STQ);
        if (invertedExecution != null && invertedExecution.booleanValue()) {
            builder.append(LBL_INVERTED);
        } else {
            builder.append(additionalFormatDescription ? "Normal" : "");
        }
        builder.append(additionalFormatDescription ? " logic test" : "");
        if (additionalFormatDescription && stqValueString != null) {
            builder.append(", Qualifier: " + stqValueString);
        }
        return builder.toString();
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        String val;
        NamedNodeMap attr;
        Node inv;
        if (xmlNode.hasAttributes() && (inv = (attr = xmlNode.getAttributes()).getNamedItem("CallNextWhenFalse")) != null && (val = inv.getNodeValue()) != null && !Boolean.parseBoolean(val)) {
            attr.removeNamedItem("CallNextWhenFalse");
        }
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node iterator, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        boolean inverted = false;
        String stq = null;
        if (iterator.hasAttributes()) {
            NamedNodeMap attributes = iterator.getAttributes();
            Node n = attributes.getNamedItem("CallNextWhenFalse");
            if (n != null) {
                String cnwfString = n.getNodeValue();
                inverted = Boolean.parseBoolean(cnwfString);
            }
            if (this.myUseSTQBehavior && (n = attributes.getNamedItem("STQvalue")) != null) {
                String stqString;
                stq = stqString = n.getNodeValue();
            }
        }
        displayValues.put(LBL_INVERTED, inverted);
        if (stq != null) {
            displayValues.put(LBL_STQ, stq);
        }
        return displayValues;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        Boolean inv = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        displayValues.put(LBL_INVERTED, inv);
        if (this.myUseSTQBehavior) {
            String stq = VarListUtil.getStringValueForName(variables, LBL_STQ);
            displayValues.put(LBL_STQ, stq);
        }
        return displayValues;
    }

    @Override
    public boolean parameterChanged(String referenceVariableLabel, Variable referenceVariable, List<Variable> variableList) {
        if (referenceVariable.getLabel().equals(LBL_STQ)) {
            assert (referenceVariable instanceof STQVariable);
            STQVariable theVariable = (STQVariable)referenceVariable;
            String value = theVariable.getValueString();
            if (!this.areEqualStrings(value, this.myCachedSTQValue)) {
                this.unregisterSTQ(this.myCachedSTQValue);
                this.registerSTQ(value);
                theVariable.updateSTQIndicationState();
                this.myCachedSTQValue = value;
            }
        }
        return false;
    }

    private boolean areEqualStrings(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    boolean isSTQUsedMoreThanOnce(String stqValue) {
        if (stqValue == null) {
            return false;
        }
        SelectionTreeQualifier stq = SelectionTreeQualifier.valueOf(stqValue);
        return this.mySTQRepository.getReferenceCountFor(stq) > 1;
    }

    @Override
    public void notifySTQChange(STQChangeEvent event) {
        assert (this.myCachedSTQValue == null || event.getReferencedSTQ().equals(SelectionTreeQualifier.valueOf(this.myCachedSTQValue))) : String.format("Got STQ notification: %s, cached STQ = %s", event, this.myCachedSTQValue);
        this.myUpdateSTQStatus = true;
    }

    protected class STQVariable
    extends WatermarkStringVariable {
        protected STQVariable() {
            super(NodeStatementProfile.LBL_STQ, NodeStatementProfile.this.createSTQDocument(NodeStatementProfile.STQ_DISPLAYSTRING), NodeStatementProfile.STQ_DISPLAYSTRING, IconIndicationType.REUSED);
        }

        protected STQVariable(String stq) {
            super(NodeStatementProfile.LBL_STQ, stq, NodeStatementProfile.this.createSTQDocument(NodeStatementProfile.STQ_DISPLAYSTRING), NodeStatementProfile.STQ_DISPLAYSTRING, IconIndicationType.REUSED);
        }

        @Override
        public Component getEditor() {
            Component c = super.getEditor();
            if (NodeStatementProfile.this.myUpdateSTQStatus) {
                this.updateSTQIndicationState(c);
                NodeStatementProfile.this.myUpdateSTQStatus = false;
            }
            return c;
        }

        void updateSTQIndicationState() {
            this.updateSTQIndicationState(this.getEditor());
        }

        private void updateSTQIndicationState(Component c) {
            boolean isDuplicate = NodeStatementProfile.this.isSTQUsedMoreThanOnce(this.getValueString());
            IconIndicableTextField editor = (IconIndicableTextField)c;
            editor.toggleIndication(isDuplicate);
            editor.setToolTipText(isDuplicate ? NodeStatementProfile.STQ_VALUE_RECYCLE_TOOLIP : null);
        }
    }
}

