/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.statements.ImmutableNodeStatement;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Immutable
public final class DefsStatement
extends ImmutableNodeStatement {
    private DefsStatement(ParseContext ctx, TariffStructureNode[] children) {
        super(ctx, children);
    }

    public static DefsStatement create(ParseContext ctx, TariffStructureNode[] children) {
        return new DefsStatement(ctx, DefsStatement.sortChildrenArray(children));
    }

    private static TariffStructureNode[] sortChildrenArray(TariffStructureNode[] children) {
        List<TariffStructureNode> childrenList = Arrays.asList(children);
        Collections.sort(childrenList, new ModifiersLastComparator());
        return childrenList.toArray(new TariffStructureNode[childrenList.size()]);
    }

    @Override
    public void execute(DataSet theData) {
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            return (DefsStatement)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        TraceInfoHelper.suppressTraceGeneration(tp);
    }

    private static class ModifiersLastComparator
    implements Comparator<TariffStructureNode> {
        private ModifiersLastComparator() {
        }

        @Override
        public int compare(TariffStructureNode o1, TariffStructureNode o2) {
            int result = 0;
            int o1Type = o1.getNodeType();
            int o2Type = o2.getNodeType();
            if (o1Type == 3 && o2Type != 3) {
                result = 1;
            } else if (o1Type != 3 && o2Type == 3) {
                result = -1;
            }
            return result;
        }
    }
}

