/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.filter;

import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.selectiontree.search.AccessTrackingConditionEvaluator;
import com.ericsson.ere.selectiontree.search.VariableHelper;
import com.ericsson.ere.selectiontree.search.filter.AbstractBranchFilter;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import com.ericsson.ere.selectiontree.search.predicate.SimulationBasedDataSetPredicateBuilder;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class SimulationBasedParameterBranchFilter
extends AbstractBranchFilter {
    private static final short FILTER_VERSION = 1;
    public static final String CONTEXT_FIELD_DELIMITER = ">";
    private Properties myParameterData;
    private ContextAwareServiceContainer myServiceContainer;
    private String myCurrentContext = null;
    private AbstractGroupedSimulationDataPanel myPanel;
    private String myExpectedServiceId;

    public SimulationBasedParameterBranchFilter(ContextAwareServiceContainer serviceContainer, String name) {
        super(name);
        if (serviceContainer == null) {
            throw new IllegalArgumentException("Service cannot be null.");
        }
        this.myServiceContainer = serviceContainer;
        this.myParameterData = new Properties();
    }

    private SimulationBasedParameterBranchFilter(String name, String serviceId, Properties props) {
        super(name);
        this.myParameterData = props;
        this.myExpectedServiceId = serviceId;
        this.updateCurrentContext();
    }

    private void updateCurrentContext() {
        this.myCurrentContext = null;
        for (String param : this.myParameterData.stringPropertyNames()) {
            String ctx = this.getParameterContext(param);
            if (ctx == null) continue;
            this.myCurrentContext = ctx;
            break;
        }
    }

    private String getParameterContext(String param) {
        String context = null;
        int idx = param.indexOf(CONTEXT_FIELD_DELIMITER);
        if (idx >= 0) {
            context = param.substring(0, idx);
        }
        return context;
    }

    public void setService(ContextAwareServiceContainer serviceContainer) {
        if (serviceContainer == null) {
            throw new IllegalArgumentException("Cannot set a null service.");
        }
        if (this.myServiceContainer != null) {
            throw new IllegalStateException("This filter already has a service.");
        }
        if (!serviceContainer.getService().getId().equals(this.myExpectedServiceId)) {
            throw new IllegalArgumentException("Wrong service ID, expected " + this.myExpectedServiceId + " but got " + serviceContainer.getService().getId() + ".");
        }
        this.myServiceContainer = serviceContainer;
    }

    @Override
    public BranchPredicate createPredicate() {
        AccessTrackingConditionEvaluator evaluator = new AccessTrackingConditionEvaluator();
        AbstractGroupedSimulationDataPanel panel = this.populatePanelFromParameterData();
        return new SimulationBasedDataSetPredicateBuilder(this.myServiceContainer, panel).createPredicate(evaluator);
    }

    private AbstractGroupedSimulationDataPanel populatePanelFromParameterData() {
        AbstractGroupedSimulationDataPanel panel = this.ensurePanelIsCreated();
        List<Variable> vars = this.getAllInputVariablesFromPanel(panel);
        this.deselectVariables(vars);
        if (this.myCurrentContext != null) {
            panel.selectContext(this.myCurrentContext);
        }
        List<Variable> commonVariables = panel.getCommonParameters();
        List<Variable> inputVariables = panel.getInputParameters();
        this.setVariableValues(commonVariables, false);
        this.setVariableValues(inputVariables, false);
        if (this.myCurrentContext != null) {
            List<Variable> contextVariables = panel.getInputParametersForSelectedContext(false);
            this.setVariableValues(contextVariables, true);
        }
        return panel;
    }

    private void setVariableValues(List<Variable> vars, boolean isContext) {
        assert (!isContext || this.myCurrentContext != null);
        for (Variable var : vars) {
            String value;
            String id = SimulationBasedParameterBranchFilter.getLabelWithoutInputSuffix(var);
            if (id.endsWith(" (OUT)")) continue;
            if (isContext) {
                id = this.myCurrentContext + CONTEXT_FIELD_DELIMITER + id;
            }
            if ((value = this.myParameterData.getProperty(id)) == null) continue;
            VariableHelper.setVariableValueString(var, value);
            var.setSelected(true);
        }
    }

    public static String getLabelWithoutInputSuffix(Variable var) {
        String ret = var.getLabel();
        if (ret.endsWith(" (IN)")) {
            ret = ret.substring(0, ret.length() - " (IN)".length());
        } else if (var instanceof GroupedObjectArrayVariable && ret.endsWith(" IN")) {
            ret = ret.substring(0, ret.length() - 3);
        }
        return ret;
    }

    private List<Variable> getAllInputVariablesFromPanel(AbstractGroupedSimulationDataPanel panel) {
        ArrayList<Variable> vars = new ArrayList<Variable>(panel.getAllInputParameters());
        vars.addAll(panel.getCommonParameters());
        return vars;
    }

    private AbstractGroupedSimulationDataPanel ensurePanelIsCreated() {
        if (this.myPanel == null) {
            if (this.myServiceContainer == null) {
                throw new IllegalStateException("No service specified.");
            }
            SimulationFactory simfact = (SimulationFactory)this.myServiceContainer.getService().getSimulationFactory();
            this.myPanel = (AbstractGroupedSimulationDataPanel)simfact.createSimulationDataPanel(this.myServiceContainer);
        }
        return this.myPanel;
    }

    private void deselectVariables(List<Variable> vars) {
        String contextFieldID = this.myServiceContainer.getClassRepository().getContextFieldIdentifier();
        for (Variable var : vars) {
            if (contextFieldID != null && contextFieldID.equals(var.getLabel())) continue;
            var.setSelected(false);
        }
    }

    public String getParameterValue(String param) {
        return this.myParameterData.getProperty(param);
    }

    public void setParameterValue(String param, String value) {
        String ctx = this.getParameterContext(param);
        if (ctx != null) {
            if (this.myCurrentContext != null && !this.myCurrentContext.equals(ctx)) {
                throw new IllegalArgumentException("Context does not match the current context: " + ctx);
            }
            this.myCurrentContext = ctx;
        }
        this.myParameterData.setProperty(param, value);
    }

    public void notifyListeners() {
        this.fireDataChanged();
    }

    public void removeParameterValue(String param) {
        this.myParameterData.remove(param);
        this.updateCurrentContext();
    }

    public void removeParameterValues() {
        this.myParameterData.clear();
        this.updateCurrentContext();
    }

    public Collection<String> getParameterNames() {
        return Collections.unmodifiableCollection(this.myParameterData.stringPropertyNames());
    }

    @Override
    public void save(OutputStream out) throws IOException {
        if (this.myServiceContainer == null) {
            throw new IllegalStateException("Service is not set");
        }
        DataOutputStream dos = SimulationBasedParameterBranchFilter.dataOutputStream(out);
        dos.writeShort(1);
        dos.writeUTF(this.getName());
        dos.writeUTF(this.myServiceContainer.getService().getId());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.myParameterData.store(bos, this.getClass().getName());
        byte[] data = bos.toByteArray();
        dos.writeInt(data.length);
        dos.write(data);
    }

    public static SimulationBasedParameterBranchFilter load(InputStream in) throws IOException {
        SimulationBasedParameterBranchFilter filter;
        DataInputStream dis = SimulationBasedParameterBranchFilter.dataInputStream(in);
        short version = dis.readShort();
        if (version > 1) {
            throw new IOException("Filter version is too new: " + version);
        }
        if (version <= 0) {
            throw new IOException("Invalid filter version: " + version);
        }
        switch (version) {
            case 1: {
                filter = SimulationBasedParameterBranchFilter.loadVersion1Filter(dis);
                break;
            }
            default: {
                throw new IOException("Unrecognized filter version: " + version);
            }
        }
        return filter;
    }

    private static SimulationBasedParameterBranchFilter loadVersion1Filter(DataInputStream dis) throws IOException {
        String name = dis.readUTF();
        String serviceId = dis.readUTF();
        int dataSize = dis.readInt();
        byte[] data = new byte[dataSize];
        dis.readFully(data);
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(data));
        return new SimulationBasedParameterBranchFilter(name, serviceId, props);
    }
}

