/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.dataset;

import com.ericsson.ere.dataset.Key;
import java.util.ArrayList;

public class DataSetParameter {
    private static final String[] EMPTY_NAMES = new String[0];
    private static final Key[] EMPTY_KEYS = new Key[0];
    private final String[] myNames;
    private final Object myIdentity1;
    private final Key[] myKeys;
    private final boolean myHasKeys;

    public DataSetParameter(Object[] identities) {
        this(null, identities);
    }

    public DataSetParameter(Key[] keys, Object[] identities) {
        ArrayList<String> names = new ArrayList<String>();
        this.myIdentity1 = identities[0];
        for (int i = 0; i < identities.length; ++i) {
            if (!(identities[i] instanceof String)) continue;
            names.add((String)identities[i]);
        }
        int count = names.size();
        this.myNames = count > 0 ? names.toArray(new String[count]) : null;
        this.myKeys = keys;
        this.myHasKeys = keys != null;
    }

    public String[] getNames() {
        if (this.myNames == null) {
            return EMPTY_NAMES;
        }
        String[] copy = new String[this.myNames.length];
        System.arraycopy(this.myNames, 0, copy, 0, copy.length);
        return copy;
    }

    public Key[] getKeys() {
        if (this.myKeys == null || this.myKeys.length == 0) {
            return EMPTY_KEYS;
        }
        Key[] keys = new Key[this.myKeys.length];
        System.arraycopy(this.myKeys, 0, keys, 0, keys.length);
        return keys;
    }

    public boolean hasKeys() {
        return this.myHasKeys;
    }

    public String toString() {
        String name = this.myNames != null ? this.myNames[0] : String.valueOf(this.myIdentity1);
        return name;
    }
}

