/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.search.ConditionEvaluator;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.interfaces.TariffStructureNode;

public class BasicConditionEvaluator
implements ConditionEvaluator {
    @Override
    public boolean test(TariffStructureNode condition, DataSet dataset) {
        boolean result;
        if (!SelectionTreeUtil.isCondition(condition)) {
            throw new IllegalArgumentException("Not a condition: " + condition.getNodeId());
        }
        if (condition.isLink()) {
            TariffStructureNode target = (TariffStructureNode)condition.getChildAt(0);
            SelectionTreeUtil.setElementData(target, ConditionEvaluator.class, this);
            return this.test(target, dataset);
        }
        if (condition.getChildCount() > 0 && condition.getChildAt(0) instanceof BranchTreeElement) {
            this.propagateEvaluatorToChildren(condition);
            result = this.evaluateCompoundCondition((Conditionality)((Object)condition), dataset);
        } else {
            result = this.evaluateCondition((Conditionality)((Object)condition), dataset);
        }
        return result;
    }

    private void propagateEvaluatorToChildren(TariffStructureNode condition) {
        int cc = condition.getChildCount();
        for (int i = 0; i < cc; ++i) {
            TariffStructureNode child = (TariffStructureNode)condition.getChildAt(i);
            SelectionTreeUtil.setElementData(child, ConditionEvaluator.class, this);
        }
    }

    protected boolean evaluateCompoundCondition(Conditionality condition, DataSet dataset) {
        boolean testResult = condition.test(dataset);
        return testResult;
    }

    protected boolean evaluateCondition(Conditionality condition, DataSet dataset) {
        boolean testResult = condition.test(dataset);
        return testResult;
    }
}

