/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.search.AccessTrackingCalendar;
import com.ericsson.ere.selectiontree.search.BasicConditionEvaluator;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.search.BranchTreeElementFactory;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.DataSetAccessLog;
import com.ericsson.ere.selectiontree.search.dataset.DataSetHelper;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameter;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameters;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccessTrackingConditionEvaluator
extends BasicConditionEvaluator {
    private static final int MAX_WORD_DISTANCE = 2;
    private final Object CT_KEY = new Object();
    private final Object ST_KEY = new Object();

    @Override
    protected boolean evaluateCompoundCondition(Conditionality condition, DataSet dataset) {
        ConditionResult cachedResult = AccessTrackingConditionEvaluator.getConditionResult(dataset, condition);
        if (cachedResult != null) {
            return cachedResult.resultOrTrueIfEmpty();
        }
        boolean result = this.evaluateCompound((TariffStructureNode)((Object)condition), dataset);
        return result;
    }

    private boolean evaluateCompound(TariffStructureNode condition, DataSet dataset) {
        this.evaluateChildrenSilently(condition, dataset);
        ArrayList<ConditionResult> childResults = new ArrayList<ConditionResult>();
        ArrayList<TariffStructureNode> childrenToConsider = new ArrayList<TariffStructureNode>();
        for (int i = 0; i < condition.getChildCount(); ++i) {
            TariffStructureNode child = (TariffStructureNode)condition.getChildAt(i);
            ConditionResult cr = AccessTrackingConditionEvaluator.getConditionResult(dataset, child);
            assert (cr != null) : "Expected the child to have a cached evaluation result.";
            if (cr.didAccessParameters()) {
                childrenToConsider.add(child);
                childResults.add(cr);
            }
            AccessTrackingConditionEvaluator.removeConditionResult(dataset, condition);
        }
        boolean result = childrenToConsider.size() > 0 ? this.evaluateCompoundConditionWithChildren(condition, dataset, childrenToConsider) : true;
        AccessTrackingConditionEvaluator.cacheResult(dataset, condition, new CompoundConditionResult(result, childResults));
        return result;
    }

    private boolean evaluateCompoundConditionWithChildren(TariffStructureNode condition, DataSet dataset, List<TariffStructureNode> children) {
        TariffStructureNode[] achildren = null;
        TariffStructureNode cond = condition;
        if (children.size() < condition.getChildCount()) {
            achildren = children.toArray(new TariffStructureNode[children.size()]);
            cond = this.createCopy(dataset.getService(), condition, achildren, dataset);
        }
        boolean result = super.evaluateCompoundCondition((Conditionality)((Object)cond), dataset);
        if (achildren != null) {
            for (int i = 0; i < achildren.length; ++i) {
                achildren[i].setParent(condition);
            }
        }
        return result;
    }

    private TariffStructureNode createCopy(Service service, TariffStructureNode condition, TariffStructureNode[] children, DataSet data) {
        TariffStructureNode copy;
        BranchTreeElementFactory factory = new BranchTreeElementFactory(service.getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(data)), null);
        try {
            copy = factory.createCondition(SelectionTreeUtil.getElementConfiguration(condition), children);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to create a condition copy.", ex);
        }
        return copy;
    }

    private void evaluateChildrenSilently(DAGNode parentCondition, DataSet dataset) {
        int cc = parentCondition.getChildCount();
        for (int i = 0; i < cc; ++i) {
            DAGNode child = parentCondition.getChildAt(i);
            ((Conditionality)((Object)child)).test(dataset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean evaluateCondition(Conditionality condition, DataSet dataset) {
        if (!(dataset instanceof AccessTrackingDataSet)) {
            throw new IllegalArgumentException("The data set must be of AccessTrackingDataSet type.");
        }
        ConditionResult cachedResult = AccessTrackingConditionEvaluator.getConditionResult(dataset, condition);
        if (cachedResult != null) {
            return cachedResult.resultOrTrueIfEmpty();
        }
        this.prepareDataSet(dataset);
        try {
            boolean testResult;
            try {
                testResult = super.evaluateCondition(condition, dataset);
            }
            catch (ClassCastException cce) {
                testResult = super.evaluateCondition(condition, ((AccessTrackingDataSet)((Object)dataset)).getDataSet());
            }
            catch (NullPointerException npe) {
                testResult = false;
            }
            catch (TreeExecutionException te) {
                testResult = false;
            }
            List<DataSetParameter> accessedParameters = this.detectAccessedParameters(dataset, condition, testResult);
            SingleConditionResult cr = new SingleConditionResult(testResult, accessedParameters);
            AccessTrackingConditionEvaluator.cacheResult(dataset, condition, cr);
            boolean bl = cr.resultOrTrueIfEmpty();
            return bl;
        }
        finally {
            this.restoreDataSetTimes(dataset);
        }
    }

    private static void cacheResult(DataSet ds, Object condition, ConditionResult result) {
        ds.putState(AccessTrackingConditionEvaluator.keyFor(condition), result);
    }

    private static ConditionResult getConditionResult(DataSet ds, Object condition) {
        TariffStructureNode tn = (TariffStructureNode)condition;
        if (tn.isLink()) {
            return AccessTrackingConditionEvaluator.getConditionResult(ds, tn.getChildAt(0));
        }
        return (ConditionResult)ds.getState(AccessTrackingConditionEvaluator.keyFor(condition));
    }

    private static void removeConditionResult(DataSet ds, Object condition) {
        TariffStructureNode tn = (TariffStructureNode)condition;
        if (tn.isLink()) {
            AccessTrackingConditionEvaluator.removeConditionResult(ds, tn.getChildAt(0));
        }
        ds.removeState(AccessTrackingConditionEvaluator.keyFor(condition));
    }

    public Collection<DataSetParameter> collectAccessedParametersForCondition(Object condition, DataSet ds) {
        Collection<DataSetParameter> result = Collections.emptyList();
        ConditionResult cr = AccessTrackingConditionEvaluator.getConditionResult(ds, condition);
        if (cr != null) {
            HashSet<DataSetParameter> set = new HashSet<DataSetParameter>();
            cr.collectAccessedParametersConditionally(set, cr.result);
            result = set;
            AccessTrackingConditionEvaluator.removeConditionResult(ds, condition);
        }
        return result;
    }

    private static Object keyFor(Object condition) {
        return "conditionresult" + System.identityHashCode(condition);
    }

    private List<DataSetParameter> detectAccessedParameters(DataSet ds, Conditionality condition, boolean testResult) {
        DataSetParameter param;
        ArrayList<DataSetParameter> found = new ArrayList<DataSetParameter>();
        DataSetAccessLog log = ((AccessTrackingDataSet)((Object)ds)).getAccessLog();
        DataSetParameters params = DataSetParameters.parametersOf(ds);
        boolean timeParameterMarkedAsUsed = false;
        for (DataSetAccessLog.ParameterAccess access : log) {
            if (access.getAccessException() != null) {
                found.clear();
                return found;
            }
            DataSetParameter param2 = this.getParameterBasedOnIDAndKey(params, access.getID(), access.getKey());
            if (param2 == null) continue;
            if (access.getID() == AccessTrackingDataSet.PARAM_TIME) {
                timeParameterMarkedAsUsed = true;
            }
            found.add(param2);
        }
        if (this.timeWasChecked(ds) && !timeParameterMarkedAsUsed && (param = params.get(AccessTrackingDataSet.PARAM_TIME)) != null) {
            found.add(param);
        }
        if (found.isEmpty() && !this.isStandardERECondition(condition)) {
            TracePoint tp = new TracePoint(ds, ds);
            tp.addInfo(TraceNodeInterface.TEST_RESULT, testResult);
            String trace = condition.describeTrace(tp);
            if (trace != null) {
                found.addAll(this.detectAccessedParametersInTrace(ds, trace));
            }
        }
        return found;
    }

    private boolean isStandardERECondition(Conditionality condition) {
        TariffStructureNode tn = (TariffStructureNode)((Object)condition);
        if (condition instanceof BranchTreeElement) {
            tn = ((BranchTreeElement)((Object)condition)).getElement();
        }
        String className = tn.getClass().getName();
        return className.startsWith("com.ericsson.ere.selectiontree.conditions.");
    }

    private DataSetParameter getParameterBasedOnIDAndKey(DataSetParameters params, Object id, Key key) {
        Object[] registeredKeys;
        Object identity = id;
        if (identity instanceof String) {
            identity = ((String)identity).toLowerCase();
        }
        DataSetParameter param = params.get(identity);
        if (key != null && !this.contains(registeredKeys = param.getKeys(), key)) {
            param = null;
        }
        return param;
    }

    private boolean contains(Object[] array, Object obj) {
        for (Object o : array) {
            if (!o.equals(obj)) continue;
            return true;
        }
        return false;
    }

    private List<DataSetParameter> detectAccessedParametersInTrace(DataSet ds, String trace) {
        ArrayList<DataSetParameter> found = new ArrayList<DataSetParameter>();
        String[] traceWords = this.splitStringIntoWords(trace);
        Set<DataSetParameter> params = DataSetParameters.parametersOf(ds).getAll();
        for (DataSetParameter param : params) {
            if (param.hasKeys()) continue;
            for (String name : param.getNames()) {
                String[] nameWords = this.splitStringIntoWords(name);
                int[] minmax = this.findMinMaxIndicesOf(traceWords, nameWords);
                if (minmax[0] < 0 || minmax[1] - minmax[0] > 2) continue;
                found.add(param);
            }
        }
        return found;
    }

    private String[] splitStringIntoWords(String str) {
        return str.toLowerCase().split("\\W*\\s+\\W*");
    }

    private int[] findMinMaxIndicesOf(String[] haystack, String[] needles) {
        List<String> list = Arrays.asList(haystack);
        int min = Integer.MAX_VALUE;
        int max = -1;
        for (int i = 0; i < needles.length; ++i) {
            int idx = list.indexOf(needles[i]);
            if (idx < min) {
                min = idx;
            }
            if (idx <= max) continue;
            max = idx;
        }
        return new int[]{min, max};
    }

    private void prepareDataSet(DataSet ds) {
        this.prepareDataSetTimes(ds);
        ((AccessTrackingDataSet)((Object)ds)).getAccessLog().clear();
    }

    private void prepareDataSetTimes(DataSet ds) {
        Calendar oldCT = ds.getCurrentTime();
        Calendar oldST = ds.getStartTime();
        AccessTrackingCalendar currentTime = new AccessTrackingCalendar();
        currentTime.setTimeInMillis(oldCT.getTimeInMillis());
        ds.setCurrentTime(currentTime);
        AccessTrackingCalendar startTime = new AccessTrackingCalendar();
        startTime.setTimeInMillis(oldST.getTimeInMillis());
        DataSetHelper.setStartTime(ds, startTime);
        ds.putState(this.CT_KEY, oldCT);
        ds.putState(this.ST_KEY, oldST);
    }

    private void restoreDataSetTimes(DataSet ds) {
        Calendar oldST;
        Calendar oldCT = (Calendar)ds.getState(this.CT_KEY);
        if (oldCT != null) {
            ds.removeState(this.CT_KEY);
            ds.setCurrentTime(oldCT);
        }
        if ((oldST = (Calendar)ds.getState(this.ST_KEY)) != null) {
            ds.removeState(this.ST_KEY);
            DataSetHelper.setStartTime(ds, oldST);
        }
    }

    private boolean timeWasChecked(DataSet ds) {
        return this.hasBeenAccessed(ds.getCurrentTime()) || this.hasBeenAccessed(ds.getStartTime());
    }

    private boolean hasBeenAccessed(Calendar cal) {
        if (cal instanceof AccessTrackingCalendar) {
            return ((AccessTrackingCalendar)cal).getAccessCount() > 0;
        }
        return false;
    }

    static class CompoundConditionResult
    extends ConditionResult {
        final List<ConditionResult> childResults;

        CompoundConditionResult(boolean result, List<ConditionResult> childResults) {
            super(result);
            this.childResults = childResults;
        }

        private boolean isNegating() {
            return this.childResults.size() == 1 && this.childResults.get((int)0).result != this.result;
        }

        @Override
        void collectAccessedParametersConditionally(Set<DataSetParameter> parameters, boolean whenResultIs) {
            boolean childWhenResultIs = this.isNegating() ? !whenResultIs : whenResultIs;
            for (ConditionResult childResult : this.childResults) {
                childResult.collectAccessedParametersConditionally(parameters, childWhenResultIs);
            }
        }

        @Override
        boolean didAccessParameters() {
            boolean didAccess = false;
            for (ConditionResult childResult : this.childResults) {
                if (!childResult.didAccessParameters()) continue;
                didAccess = true;
                break;
            }
            return didAccess;
        }
    }

    static class SingleConditionResult
    extends ConditionResult {
        final Collection<DataSetParameter> accessedParameters;

        SingleConditionResult(boolean result, Collection<DataSetParameter> params) {
            super(result);
            this.accessedParameters = params == null ? Collections.emptyList() : params;
        }

        @Override
        void collectAccessedParametersConditionally(Set<DataSetParameter> parameters, boolean whenResultIs) {
            if (this.result == whenResultIs) {
                parameters.addAll(this.accessedParameters);
            }
        }

        @Override
        boolean didAccessParameters() {
            return !this.accessedParameters.isEmpty();
        }
    }

    static abstract class ConditionResult {
        final boolean result;

        ConditionResult(boolean result) {
            this.result = result;
        }

        boolean resultOrTrueIfEmpty() {
            return this.didAccessParameters() ? this.result : true;
        }

        abstract void collectAccessedParametersConditionally(Set<DataSetParameter> var1, boolean var2);

        abstract boolean didAccessParameters();
    }
}

