/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation.strategy;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

public class WrapAroundStrategy
extends RangeStrategy {
    public static final RatingDecimal ONE = new RatingDecimal(1L, 1L);

    @Override
    public Number calculateResult(BigInteger proposedResult, BigInteger max, BigInteger min, DataType targetType) {
        if (max == null && min == null) {
            max = (BigInteger)targetType.getMaximumValue();
            min = (BigInteger)targetType.getMinimumValue();
        }
        if (max != null && proposedResult.compareTo(max) == 1) {
            BigInteger delta = proposedResult.subtract(max);
            delta = delta.mod(max.subtract(min).add(BigInteger.ONE));
            return min.add(delta).subtract(BigInteger.ONE);
        }
        if (min != null && proposedResult.compareTo(min) == -1) {
            BigInteger delta = min.subtract(proposedResult);
            delta = delta.mod(max.subtract(min).add(BigInteger.ONE));
            return max.subtract(delta).add(BigInteger.ONE);
        }
        return proposedResult;
    }

    @Override
    public RatingDecimal calculateResult(RatingDecimal proposedResult, RatingDecimal max, RatingDecimal min, DataType targetType) {
        throw new UnsupportedOperationException("WrapAroundStrategy is not supported for RatingDecimals");
    }
}

