/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DefaultMathOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.NumericIntegerFieldOperation;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

public abstract class AbstractNumericFieldOperation<T extends Number>
extends AbstractOperation<T, Number>
implements NumericIntegerFieldOperation {
    private BigInteger myMin;
    private BigInteger myMax;
    private DefaultMathOperation myOperation = DefaultMathOperation.ADD;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != DefaultMathOperation.SET;
    }

    @Override
    public String getOperation() {
        return this.myOperation.toString();
    }

    @Override
    public void setMinMax(String max, String min) {
        DataType dt = this.myFieldToAffect.getDataType();
        if (min != null && max != null) {
            this.myMax = this.toBigInteger((Number)dt.parseValue(max), dt);
            this.myMin = this.toBigInteger((Number)dt.parseValue(min), dt);
        } else {
            this.myMin = null;
            this.myMax = null;
        }
    }

    @Override
    public String[] getOperationNames() {
        return DefaultMathOperation.getOperationNames();
    }

    @Override
    protected T perform(T initialValue, Number operandValue, DataSet dataset) {
        DataType destType = this.myFieldToAffect.getDataType();
        BigInteger operand1 = this.toBigInteger((Number)initialValue, destType);
        BigInteger operand2 = this.toBigInteger(operandValue, this.myOperandDataType);
        BigInteger result = (BigInteger)this.myOperation.performNumber(operand1, operand2, this.myMax, this.myMin, destType, dataset);
        return this.fromBigInteger(result);
    }

    protected BigInteger toBigInteger(Number number, DataType dataType) {
        BigInteger big = null;
        if (number != null) {
            long valueAsLong = number.longValue();
            big = BigInteger.valueOf(valueAsLong);
            if (dataType.isUnsignedNumeric() && valueAsLong < 0L) {
                BigInteger max = (BigInteger)dataType.getMaximumValue();
                big = big.add(max).add(BigInteger.ONE);
            }
        }
        return big;
    }

    protected abstract T fromBigInteger(BigInteger var1);

    @Override
    public void setOperation(String operationStr) {
        this.myOperation = DefaultMathOperation.getOperation(operationStr);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myMax == null ? 0 : this.myMax.hashCode());
        result = 31 * result + (this.myMin == null ? 0 : this.myMin.hashCode());
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNumericFieldOperation other = (AbstractNumericFieldOperation)obj;
        if (this.myMax == null ? other.myMax != null : !this.myMax.equals(other.myMax)) {
            return false;
        }
        if (this.myMin == null ? other.myMin != null : !this.myMin.equals(other.myMin)) {
            return false;
        }
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation));
    }
}

