/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.operation.DefaultMathOperation;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;

@Immutable
public class NumericDestinationFieldInfo
extends AbstractDestinationFieldInfo {
    private final Object myDestinationMax;
    private final Object myDestinationMin;

    public NumericDestinationFieldInfo(FieldDefinition field, FieldIndexKeyContainer key) {
        super(field, key);
        DataType dt = this.getDestinationDataType();
        if (!dt.isNumeric()) {
            throw new IllegalArgumentException("Destination data type not supported: " + dt);
        }
        String max = FieldDefinitionHelper.getMaxValue(field);
        String min = FieldDefinitionHelper.getMinValue(field);
        if (min != null && max != null) {
            this.myDestinationMax = dt.parseValue(max);
            this.myDestinationMin = dt.parseValue(min);
        } else {
            this.myDestinationMax = null;
            this.myDestinationMin = null;
        }
    }

    @Override
    public Object convertValue(DataSet dataSet, Object resultValue) {
        DataType dt = this.getDestinationDataType();
        RatingDecimal value = RatingDecimalUtil.createRatingDecimalFromNumericValue(resultValue);
        RatingDecimal max = this.myDestinationMax == null ? null : RatingDecimalUtil.createRatingDecimalFromNumericValue(this.myDestinationMax);
        RatingDecimal min = this.myDestinationMin == null ? null : RatingDecimalUtil.createRatingDecimalFromNumericValue(this.myDestinationMin);
        RatingDecimal finalValue = DefaultMathOperation.SET.performRatingDecimal(null, value, max, min, dt, dataSet);
        Object ret = RatingDecimalUtil.convertRatingDecimalToValueOfDataType(dt, finalValue);
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myDestinationMax == null ? 0 : this.myDestinationMax.hashCode());
        result = 31 * result + (this.myDestinationMin == null ? 0 : this.myDestinationMin.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericDestinationFieldInfo other = (NumericDestinationFieldInfo)obj;
        if (this.myDestinationMax == null ? other.myDestinationMax != null : !this.myDestinationMax.equals(other.myDestinationMax)) {
            return false;
        }
        return !(this.myDestinationMin == null ? other.myDestinationMin != null : !this.myDestinationMin.equals(other.myDestinationMin));
    }
}

