/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitOperand;
import com.ericsson.ere.expression.Units;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.XMLUtil;
import java.util.List;
import java.util.Stack;

public class ExpressionXMLFormatter
implements ExpressionFormatter {
    protected Stack<Boolean> mySubExpressionUsage = new Stack();
    protected final boolean myWriteSubExpressions;
    protected int myIndentLevel;
    private transient StringBuilder myBuilder;

    public ExpressionXMLFormatter() {
        this(false);
    }

    public ExpressionXMLFormatter(boolean newStyle) {
        this.myWriteSubExpressions = newStyle;
    }

    @Override
    public synchronized String format(Expression expr) {
        this.myBuilder = new StringBuilder();
        this.doFormat(expr);
        return this.myBuilder.toString();
    }

    private void doFormat(Expression expr) {
        List<ExpressionToken> tokens = expr.getExpressionTokens();
        this.myIndentLevel = 0;
        this.writeExpressionPreamble(expr);
        ExpressionToken previousToken = null;
        for (ExpressionToken token : tokens) {
            this.writeExpressionToken(previousToken, token);
            previousToken = token;
        }
        this.writeExpressionPostamble(expr);
    }

    protected void writeExpressionToken(ExpressionToken previousToken, ExpressionToken token) {
        if (token instanceof Function) {
            this.writeFunction((Function)token);
        } else if (token instanceof Operator) {
            this.writeOperator((Operator)token);
        } else if (token instanceof Operand) {
            this.writeOperandToken((Operand)token, null);
        } else {
            if (this.isSubExpressionStart(token)) {
                boolean writeSubExpr = previousToken instanceof Function ? false : this.myWriteSubExpressions;
                this.mySubExpressionUsage.push(writeSubExpr);
            }
            this.writeToken(token);
            if (this.isSubExpressionEnd(token)) {
                this.mySubExpressionUsage.pop();
            }
        }
    }

    protected void writeOperandToken(Operand operand, Unit unit) {
        if (operand instanceof ValueFieldCompositeOperand) {
            ValueFieldCompositeOperand vo = (ValueFieldCompositeOperand)operand;
            ValueFieldCompositeObject value = vo.getValue();
            ValueFieldCompositeObject index = vo.getIndex();
            this.writeOperand(value, index, unit);
        } else if (operand instanceof ValueOperand) {
            Object value = ((ValueOperand)operand).getValue(null);
            DataType valueType = DataType.fromObjectClass(value);
            String strValue = valueType == null ? String.valueOf(value) : valueType.makeParseableString(value);
            ValueFieldCompositeObject vfco = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, strValue, valueType);
            this.writeOperand(vfco, null, unit);
        } else if (operand instanceof UnitOperand) {
            UnitOperand uo = (UnitOperand)operand;
            Unit u = uo.getUnit();
            Operand inner = uo.getOperand();
            this.writeOperandToken(inner, u);
        } else {
            throw new ExpressionException("Unrecognized operand type: " + operand.getClass());
        }
    }

    protected void writeOperand(ValueFieldCompositeObject value, ValueFieldCompositeObject index, Unit unit) {
        this.appendTabs();
        if (unit == null) {
            this.appendOpeningTagNL("Operand");
        } else {
            String strUnit = this.getUnitName(unit);
            if (strUnit == null) {
                throw new ExpressionException("Unrecognized unit: " + unit.getClass().getName());
            }
            this.appendTagWithAttributeNL("Operand", "unit", strUnit, false);
        }
        this.writeValueObject("V", value);
        if (index != null) {
            this.writeValueObject("I", index);
        }
        this.appendTabs().appendClosingTagNL("Operand");
    }

    protected String getUnitName(Unit unit) {
        String strUnit = Units.getUnitName(unit);
        return strUnit;
    }

    protected void writeOperand(ValueFieldCompositeObject value, ValueFieldCompositeObject index) {
        this.writeOperand(value, index, null);
    }

    protected void writeValueObject(String tag, ValueFieldCompositeObject object) {
        this.appendTabs();
        this.myBuilder.append(XMLUtil.wrapXMLInTag(tag, object.getXMLRepresentation()));
        this.myBuilder.append('\n');
    }

    protected void writeExpressionPreamble(Expression expr) {
        this.appendTabs().appendTagWithAttributeNL("Expression", "notation", (Object)expr.getNotation(), false);
        ++this.myIndentLevel;
    }

    protected void writeExpressionPostamble(Expression expr) {
        --this.myIndentLevel;
        this.appendClosingTagNL("Expression");
    }

    protected void writeToken(ExpressionToken token) {
        boolean isSubExpressionStart = this.isSubExpressionStart(token);
        boolean isSubExpressionEnd = this.isSubExpressionEnd(token);
        boolean useSubExpr = this.mySubExpressionUsage.peek();
        if (isSubExpressionEnd) {
            --this.myIndentLevel;
        }
        if (useSubExpr && isSubExpressionStart) {
            this.appendTabs().appendOpeningTagNL("SubExpression");
        } else if (useSubExpr && isSubExpressionEnd) {
            this.appendTabs().appendClosingTagNL("SubExpression");
        } else {
            String tok = XMLUtil.escape(token.toString());
            this.appendTabs().appendTagWithAttributeNL("Token", "name", tok, true);
        }
        if (isSubExpressionStart) {
            ++this.myIndentLevel;
        }
    }

    private boolean isSubExpressionEnd(ExpressionToken token) {
        return token.equals(ExpressionToken.RIGHT_PAREN);
    }

    protected final boolean isSubExpressionStart(ExpressionToken token) {
        return token.equals(ExpressionToken.LEFT_PAREN);
    }

    protected void writeOperator(Operator oper) {
        String name = this.getOperatorName(oper);
        if (name == null) {
            throw new ExpressionException("Cannot find a name for the operator: " + oper);
        }
        name = XMLUtil.escape(name);
        this.appendTabs().appendTagWithAttributeNL("Operator", "name", name, true);
    }

    protected String getOperatorName(Operator oper) {
        String name = Operators.getOperatorName(oper);
        if (name == null) {
            name = "#" + this.getCustomOperatorName(oper);
        }
        return name;
    }

    protected String getCustomOperatorName(Operator oper) {
        throw new UnsupportedOperationException("Must be implemented in a sub class.");
    }

    protected void writeFunction(Function func) {
        String name = Functions.getFunctionName(func);
        if (name == null) {
            name = "$" + func.getFunctionName();
        }
        name = XMLUtil.escape(name);
        this.appendTabs().appendTagWithAttributeNL("Function", "name", name, true);
    }

    protected final ExpressionXMLFormatter appendOpeningTagNL(String tag) {
        this.myBuilder.append('<').append(tag).append(">\n");
        return this;
    }

    protected final ExpressionXMLFormatter appendClosingTagNL(String tag) {
        this.myBuilder.append("</").append(tag).append(">\n");
        return this;
    }

    protected final ExpressionXMLFormatter appendTagWithAttributeNL(String tag, String attribute, Object value, boolean close) {
        this.myBuilder.append('<').append(tag);
        this.myBuilder.append(XMLUtil.wrapInAttribute(attribute, value));
        if (close) {
            this.myBuilder.append(" />");
        } else {
            this.myBuilder.append('>');
        }
        this.myBuilder.append('\n');
        return this;
    }

    protected final ExpressionXMLFormatter appendTabs() {
        for (int i = 0; i < this.myIndentLevel; ++i) {
            this.myBuilder.append('\t');
        }
        return this;
    }
}

