/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.jump;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.selectiontree.CircularJumpException;
import com.ericsson.ere.selectiontree.NoTreeFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class GoToModifier
extends ImmutableModifier
implements TraceableV2 {
    private final SelectionTreeDestination myGoToTree;
    private final ClassRepository myRepository;
    public static final String TAG_GOTO = "GoTo";
    public static final String ATTR_PLAN = "Plan";
    public static final String ATTR_PROVIDER = "Provider";
    public static final String ATTR_SERVICE = "Service";

    private GoToModifier(ParseContext ctx) {
        super(ctx);
        Node iterator = ctx.getXMLNode();
        NodeList children = iterator.getChildNodes();
        Element theGoToNode = XMLUtil.getNamedElement(TAG_GOTO, children);
        this.myGoToTree = new SelectionTreeDestination(theGoToNode);
        this.myRepository = ctx.getClassRepository();
    }

    public static GoToModifier create(ParseContext ctx, TariffStructureNode[] children) {
        if (ctx == null) {
            throw new IllegalArgumentException("Argument ctx must not be null");
        }
        return new GoToModifier(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myGoToTree == null ? 0 : this.myGoToTree.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoToModifier other = (GoToModifier)obj;
        if (this.myGoToTree == null ? other.myGoToTree != null : !this.myGoToTree.equals(other.myGoToTree)) {
            return false;
        }
        return !(this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository));
    }

    @Override
    public void perform(DataSet theData) {
        RatingPlan ratingPlan = this.myRepository.getJumperSupport().getRatingPlan(this.myGoToTree);
        if (ratingPlan != null) {
            if (theData.getState(ratingPlan.getIdentity()) != null) {
                throw new CircularJumpException("Circular tree jump not allowed. Circular jump exist for Rating rule tree '" + ratingPlan.getIdentity() + "'.");
            }
        } else {
            throw new NoTreeFoundException("Error in configuration. Rating Plan missing.");
        }
        theData.putState(ratingPlan.getIdentity(), ratingPlan.getIdentity());
        theData.setCurrentRatingPlan(ratingPlan);
        theData.setCurrentServiceProvider(this.myGoToTree.getProviderName());
        theData.execute(ratingPlan, theData.getStartTime());
        theData.removeState(ratingPlan.getIdentity());
        theData.stopExecution();
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuffer buf = new StringBuffer();
        buf.append("GoTo : jump to rating plan '").append(this.myGoToTree).append("' from\n");
        buf.append("       originating rating plan '").append(this.myRatingPlan).append("'");
        return buf.toString();
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }
}

