/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.AbstractSetFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.NoActionStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
public final class SetRatingDecimalFieldModifier
extends AbstractSetFieldModifier<RatingDecimal> {
    private SetRatingDecimalFieldModifier(ParseContext ctx) {
        super(ctx, DataType.RATINGDECIMAL);
    }

    public static SetRatingDecimalFieldModifier create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new SetRatingDecimalFieldModifier(ctx);
    }

    @Override
    protected RatingDecimal applyStrategyOnValue(RatingDecimal value, DataSet theData) {
        RangeStrategy strategy = theData instanceof AbstractDataSet ? ((AbstractDataSet)theData).getSetFieldRangeStrategy() : new NoActionStrategy();
        RatingDecimal max = RatingDecimalUtil.createRatingDecimalFromNumericValue(this.myMax);
        RatingDecimal min = RatingDecimalUtil.createRatingDecimalFromNumericValue(this.myMin);
        RatingDecimal resultingValue = strategy.calculateResult(value, max, min, DataType.RATINGDECIMAL);
        return resultingValue;
    }
}

