/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.InfixOperatorRules;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.PostfixEvaluator;
import com.ericsson.ere.expression.ShuntingYardConverter;
import com.ericsson.ere.expression.StandardInfixOperatorRules;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.AmountDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import com.ericsson.ere.selectiontree.modifiers.mfo.DateDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.DestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationConfiguration;
import com.ericsson.ere.selectiontree.modifiers.mfo.NumericDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.ResolvingInfixExpressionFormatter;
import com.ericsson.ere.selectiontree.modifiers.mfo.StringDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.TimeDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.TrafficExpressionXMLReader;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.w3c.dom.Node;

@Immutable
public class MultiFieldOperation
extends ImmutableModifier
implements TraceableV2 {
    private static final String NO_VALUE = "NO VALUE";
    private static final String NO_VALUES = "NO VALUES";
    private static final Object FORMATS = new Object();
    private final Expression myExpression;
    private final DestinationFieldInfo myDestinationFieldInfo;
    private final transient Expression myOriginalInfixExpression;

    protected MultiFieldOperation(ParseContext ctx, String destinationField, FieldIndexKeyContainer index, Expression expression, Expression originalExpression) {
        super(ctx);
        this.myExpression = expression;
        this.myOriginalInfixExpression = originalExpression;
        this.myDestinationFieldInfo = this.createDestinationFieldInfo(ctx.getClassRepository(), destinationField, index);
    }

    protected DestinationFieldInfo createDestinationFieldInfo(ClassRepository rep, String destinationField, FieldIndexKeyContainer key) {
        AbstractDestinationFieldInfo ret;
        FieldDefinition field = this.getFieldOrThrow(rep, destinationField);
        DataType dt = field.getTypedDataType();
        switch (dt) {
            case DATE: {
                ret = new DateDestinationFieldInfo(field, key);
                break;
            }
            case AMOUNT: {
                ret = new AmountDestinationFieldInfo(field, key);
                break;
            }
            case TIME: {
                ret = new TimeDestinationFieldInfo(field, key);
                break;
            }
            case STRING: {
                ret = new StringDestinationFieldInfo(field, key);
                break;
            }
            default: {
                if (dt.isNumeric()) {
                    ret = new NumericDestinationFieldInfo(field, key);
                    break;
                }
                throw new UnsupportedOperationException("Destination field data type not yet supported: " + dt);
            }
        }
        return ret;
    }

    protected FieldDefinition getFieldOrThrow(ClassRepository repository, String name) {
        FieldDefinition field = repository.getFieldDefinitionByName(name);
        if (field == null) {
            throw new IllegalArgumentException("Field not found in class repository: " + name);
        }
        return field;
    }

    public static MultiFieldOperation create(ParseContext ctx, TariffStructureNode[] unused) {
        return MultiFieldOperation.create(ctx, DefaultDataSetValueReader.INSTANCE);
    }

    protected static MultiFieldOperation create(ParseContext ctx, DataSetValueReader reader) {
        ClassRepository rep = ctx.getClassRepository();
        return MultiFieldOperation.create(ctx, new TrafficExpressionXMLReader(rep, reader), (InfixOperatorRules)new StandardInfixOperatorRules());
    }

    protected static MultiFieldOperation create(ParseContext ctx, AbstractExpressionXMLReader xmlReader, InfixOperatorRules operatorRules) {
        Node config = ctx.getXMLNode();
        MultiFieldOperationConfiguration mfoConfig = MultiFieldOperationConfiguration.readConfig(ctx.getClassRepository(), config, xmlReader);
        return MultiFieldOperation.create(ctx, mfoConfig, operatorRules);
    }

    protected static MultiFieldOperation create(ParseContext ctx, MultiFieldOperationConfiguration mfoConfig, InfixOperatorRules operatorRules) {
        FieldIndexKeyContainer.KeyType ktype;
        String destField = mfoConfig.getDestinationField();
        FieldIndexKeyContainer key = mfoConfig.getKeyContainer();
        if (mfoConfig.getKey() != null && (ktype = FieldOrientedPluginUtil.getKeyTypeForField(destField, ctx.getClassRepository())) == null) {
            throw new IllegalArgumentException("Found key/index for a non-indexable field (" + destField + ").");
        }
        Expression expr = mfoConfig.getExpression();
        if (expr.getNotation() != Expression.ExpressionNotation.INFIX) {
            throw new IllegalArgumentException("MultiFieldOperation requires an INFIX expression.");
        }
        Expression postfix = expr.convert(new ShuntingYardConverter(operatorRules));
        return MultiFieldOperation.createNew(ctx, destField, key, postfix, expr);
    }

    private static MultiFieldOperation createNew(ParseContext ctx, String destinationField, FieldIndexKeyContainer index, Expression expression, Expression originalExpression) {
        MultiFieldOperation ret;
        if (ctx instanceof MultiFieldOperationParseContext) {
            MultiFieldOperationParseContext mpc = (MultiFieldOperationParseContext)ctx;
            ret = mpc.createNew(destinationField, index, expression, originalExpression);
        } else {
            ret = new MultiFieldOperation(ctx, destinationField, index, expression, originalExpression);
        }
        FieldOrientedPluginUtil.checkMissingFields(ret, ctx.getClassRepository());
        return ret;
    }

    @Override
    public void perform(final DataSet theData) {
        final PostfixEvaluator evaluator = new PostfixEvaluator();
        DataSetEvaluationContext context = new DataSetEvaluationContext(){

            @Override
            public DataSet getDataSet() {
                return theData;
            }

            @Override
            public ExpressionEvaluator getEvaluator() {
                return evaluator;
            }
        };
        try {
            Operand result = this.myExpression.evaluate(context);
            Object value = result.getValue(context);
            this.storeResult(theData, value);
        }
        catch (RuntimeException e) {
            throw new TreeExecutionException(e);
        }
    }

    protected void storeResult(DataSet dataSet, Object resultValue) {
        Object finalValue = this.myDestinationFieldInfo.convertValue(dataSet, resultValue);
        this.setDestinationFieldValue(dataSet, finalValue);
    }

    protected void setDestinationFieldValue(DataSet dataSet, Object value) {
        DestinationFieldInfo info = this.myDestinationFieldInfo;
        DataSetField destField = info.getDestinationField();
        if (info.useKeyForDestination()) {
            Key[] keys;
            FieldIndexKeyContainer fieldKeyContainer = info.retrieveKeyContainerForDestination();
            for (Key key : keys = fieldKeyContainer.getKeySet(dataSet)) {
                destField.setValueInDataSet(dataSet, key, value);
            }
        } else {
            destField.setValueInDataSet(dataSet, value);
        }
    }

    protected Object[] getDestinationFieldValues(DataSet dataSet) {
        Object[] values;
        DestinationFieldInfo info = this.myDestinationFieldInfo;
        DataSetField destField = info.getDestinationField();
        if (info.useKeyForDestination()) {
            FieldIndexKeyContainer fieldKeyContainer = info.retrieveKeyContainerForDestination();
            Key[] keys = fieldKeyContainer.getKeySet(dataSet);
            values = new Object[keys.length];
            boolean containsValue = false;
            for (int i = 0; i < values.length; ++i) {
                try {
                    values[i] = destField.getValueFromDataSet(dataSet, keys[i]);
                    containsValue = true;
                    continue;
                }
                catch (DataSetValueNotFoundException e) {
                    values[i] = NO_VALUE;
                }
            }
            if (!containsValue && values.length > 1) {
                values = new Object[]{NO_VALUES};
            }
        } else {
            Object value;
            try {
                value = destField.getValueFromDataSet(dataSet);
            }
            catch (DataSetValueNotFoundException e) {
                value = NO_VALUE;
            }
            values = new Object[]{value};
        }
        return values;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet preDataSet = TraceDataSet.createPreDataSet(tp);
        TraceDataSet postDataSet = TraceDataSet.createPostDataSet(tp);
        Object[] newValues = this.getDestinationFieldValues(postDataSet);
        Object newValue = newValues[0];
        StringBuilder trace = new StringBuilder();
        String[] formats = (String[])tp.getInfo(FORMATS);
        String firstRowPrefix = this.describeDestinationFieldWithValue(preDataSet) + " = ";
        String restRowPrefix = this.createWhitespace(firstRowPrefix.length() - 2) + "= ";
        for (int i = 0; i < formats.length; ++i) {
            String prefix;
            String string = prefix = i == 0 ? firstRowPrefix : restRowPrefix;
            if (i > 0) {
                trace.append('\n');
            }
            trace.append(prefix);
            trace.append(formats[i]);
            trace.append(" =");
        }
        DataType fieldType = this.myDestinationFieldInfo.getDestinationField().getDataType();
        trace.append(' ').append(this.valuesToString(new Object[]{newValue}, fieldType));
        return trace.toString();
    }

    protected final String[] getExpressionFormats(Expression e, DataSet ds) {
        ResolvingInfixExpressionFormatter.ResolutionLevel[] levels;
        ArrayList<String> ret = new ArrayList<String>();
        for (ResolvingInfixExpressionFormatter.ResolutionLevel l : levels = new ResolvingInfixExpressionFormatter.ResolutionLevel[]{ResolvingInfixExpressionFormatter.ResolutionLevel.NONE, ResolvingInfixExpressionFormatter.ResolutionLevel.INDEXES_ONLY, ResolvingInfixExpressionFormatter.ResolutionLevel.FULL}) {
            String desc = ResolvingInfixExpressionFormatter.format(e, ds, l);
            if (!ret.isEmpty() && desc.equals(ret.get(ret.size() - 1))) continue;
            ret.add(desc);
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected final String createWhitespace(int i) {
        char[] chars = new char[i];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    protected String describeDestinationFieldWithValue(DataSet dataSet) {
        DestinationFieldInfo info = this.myDestinationFieldInfo;
        StringBuilder builder = new StringBuilder();
        String fieldName = info.getDestinationField().getFieldName();
        DataType fieldType = info.getDestinationField().getDataType();
        if (info.useKeyForDestination()) {
            builder.append(FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(fieldName, info.retrieveKeyContainerForDestination(), dataSet));
        } else {
            builder.append(fieldName);
        }
        Object[] values = this.getDestinationFieldValues(dataSet);
        builder.append(" (").append(this.valuesToString(values, fieldType)).append(')');
        return builder.toString();
    }

    protected final String valuesToString(Object[] values, DataType dataType) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.makeDisplayString(values[i], dataType));
        }
        return b.toString();
    }

    protected String makeDisplayString(Object value, DataType dataType) {
        String ret = NO_VALUE.equals(value) || NO_VALUES.equals(value) ? value.toString() : (dataType == DataType.RATINGDECIMAL ? RatingDecimalUtil.toString((RatingDecimal)value) : dataType.makeDisplayString(value));
        return ret;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        DataSetField destField = this.myDestinationFieldInfo.getDestinationField();
        FieldIndexKeyContainer keyContainer = this.myDestinationFieldInfo.retrieveKeyContainerForDestination();
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(destField, keyContainer, tp);
        String[] formats = this.getExpressionFormats(this.myOriginalInfixExpression, tp.getPreDataSet());
        tp.addInfo(FORMATS, formats);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        DataSetField destField = this.myDestinationFieldInfo.getDestinationField();
        FieldIndexKeyContainer keyContainer = this.myDestinationFieldInfo.retrieveKeyContainerForDestination();
        PluginTraceHelper.addFieldValueAsPostDataInTracePoint(destField, keyContainer, tp);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myDestinationFieldInfo == null ? 0 : this.myDestinationFieldInfo.hashCode());
        result = 31 * result + (this.myExpression == null ? 0 : this.myExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        MultiFieldOperation other = (MultiFieldOperation)obj;
        if (this.myDestinationFieldInfo == null ? other.myDestinationFieldInfo != null : !this.myDestinationFieldInfo.equals(other.myDestinationFieldInfo)) {
            return false;
        }
        return !(this.myExpression == null ? other.myExpression != null : !this.myExpression.equals(other.myExpression));
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.add(this.myDestinationFieldInfo.getDestinationField().getFieldName());
        FieldIndexKeyContainer key = this.myDestinationFieldInfo.retrieveKeyContainerForDestination();
        if (key != null) {
            set.addAll(key.getUsedFields());
        }
        set.addAll(this.myExpression.getUsedFields());
        return set;
    }

    protected static class MultiFieldOperationParseContext
    extends ParseContextAdapter {
        protected MultiFieldOperationParseContext(ParseContext original) {
            super(original);
        }

        protected MultiFieldOperation createNew(String destinationField, FieldIndexKeyContainer index, Expression expression, Expression originalExpression) {
            return new MultiFieldOperation(this, destinationField, index, expression, originalExpression);
        }
    }
}

