/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.ClearValueProfileContract;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Constrainable(contractClass=ClearValueProfileContract.class)
public class ClearValueProfile
extends AbstractFieldOrientedModifierProfile {
    private static final String INDEX_NOT_ALLOWED_MSG = "Indexing is no longer allowed for the selected field";
    private static final String INDEX_MANDATORY_MSG = "Indexing is mandatory for the selected field";
    public static final String LBL_FIELD = "Field";
    public static final String LBL_FIELD_INDEX = "Index";
    public static final String LBL_CLEARKEY = "Clear value for key";
    private static final String MSG_NO_FIELDS_EXISTS = "No available fields found";
    private static final List<String> PARAM_TYPES = new ArrayList<String>(Arrays.asList(ClassRepository.OUTPUT_TYPES));
    private static final String HIDE_MAP_ENTRY_OPTION_FEATURE = "Hide_Map_Entry_Option";
    private static final String FORCE_MAP_ENTRY_OPTION_FEATURE = "Force_Map_Entry_Option";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private boolean mySupportDateTimeInteroperability = false;

    @Override
    public boolean parameterChanged(String variableLabel, Variable modifiedVariable, List<Variable> vars) {
        boolean updated = false;
        if (LBL_FIELD.equals(variableLabel)) {
            String fieldName = modifiedVariable.getValueString();
            updated |= VarListUtil.removeVariablesByKey(vars, LBL_FIELD_INDEX);
            updated |= VarListUtil.removeVariablesByLabel(vars, LBL_CLEARKEY);
            updated |= vars.addAll(this.createMapEntryOptionVariables(fieldName, null, true));
        } else if (LBL_CLEARKEY.equals(variableLabel)) {
            boolean clearUsingKey = Boolean.valueOf(modifiedVariable.getValueString());
            String fieldName = VarListUtil.getValueStringForName(vars, LBL_FIELD);
            updated |= VarListUtil.removeVariablesByKey(vars, LBL_FIELD_INDEX);
            MapEntryOption option = this.investigateMapEntryOption(fieldName);
            if (clearUsingKey) {
                switch (option) {
                    case FORCE_MAP_ENTRY: {
                        modifiedVariable.setAllowEdit(false);
                        this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, null, vars, this.createIndexVariableFactory());
                        break;
                    }
                    case SHOW_MAP_ENTRY: {
                        this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, null, vars, this.createIndexVariableFactory());
                        break;
                    }
                    case HIDE_MAP_ENTRY: {
                        modifiedVariable.setAllowEdit(true);
                        vars.add(this.createNotAllowedVariable(INDEX_NOT_ALLOWED_MSG));
                        break;
                    }
                }
                updated = true;
            } else {
                switch (option) {
                    case FORCE_MAP_ENTRY: {
                        modifiedVariable.setAllowEdit(true);
                        vars.add(this.createNotAllowedVariable(INDEX_MANDATORY_MSG));
                        updated = true;
                        break;
                    }
                    case HIDE_MAP_ENTRY: {
                        modifiedVariable.setAllowEdit(false);
                        updated = true;
                        break;
                    }
                }
            }
        }
        return updated;
    }

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(null, null, true);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        Element fieldElement = XMLUtil.getNamedElement(LBL_FIELD, children);
        Element indexElement = XMLUtil.getNamedElement(LBL_FIELD_INDEX, children);
        String fieldNameFromElement = fieldElement.getFirstChild().getNodeValue();
        String fieldName = fieldNameFromElement == null ? "" : fieldNameFromElement;
        return this.getVariables(fieldName, indexElement, false);
    }

    private List<Variable> getVariables(String fieldName, Element indexElement, boolean createDefaultIndexIfMissing) {
        ArrayList<Variable> varList = new ArrayList<Variable>(3);
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withFilter(new MyFieldFilter()).withConstraints(this, null);
        Variable fieldsDropDown = this.createFieldsDropDown(fieldName, builder, LBL_FIELD);
        varList.add(fieldsDropDown);
        if (!(fieldsDropDown instanceof NotAllowedVariable)) {
            String selectedFieldName = fieldsDropDown.getValueString();
            varList.addAll(this.createMapEntryOptionVariables(selectedFieldName, indexElement, createDefaultIndexIfMissing));
        }
        return varList;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fieldName;
        ValueFieldCompositeObject indexObject = null;
        Variable fieldVariable = VarListUtil.getVariableForName(variables, LBL_FIELD);
        if (fieldVariable == null || fieldVariable instanceof NotAllowedVariable) {
            fieldName = "";
        } else {
            fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD);
            indexObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX));
        }
        StringBuffer text = new StringBuffer();
        text.append(this.getIndents(indentLevel, indentMarker)).append(XMLUtil.wrapInTag(LBL_FIELD, fieldName)).append("\n");
        if (indexObject != null) {
            text.append(XMLUtil.wrapXMLInTag(LBL_FIELD_INDEX, indexObject.getXMLRepresentation()));
        }
        out.println(text);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        Variable fieldVariable = VarListUtil.getVariableForName(variables, LBL_FIELD);
        StringBuilder text = new StringBuilder(this.getName());
        text.append(" (");
        if (fieldVariable instanceof NotAllowedVariable) {
            text.append(MSG_NO_FIELDS_EXISTS);
        } else {
            text.append(this.createText(variables, fieldVariable.getValueString()));
        }
        text.append(")");
        return text.toString();
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        Variable fieldVariable = VarListUtil.getVariableForName(variables, LBL_FIELD);
        StringBuilder text = new StringBuilder("<b>").append(this.getName()).append("</b>");
        text.append(" (");
        if (fieldVariable instanceof NotAllowedVariable) {
            text.append(MSG_NO_FIELDS_EXISTS);
        } else {
            text.append(this.createText(variables, fieldVariable.getValueString()));
        }
        text.append(")\n").append(this.getComment(variables));
        return GuiUtil.multilineTooltipWrapper(text.toString());
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(this.myClassRepository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, ClearValueProfile.getCandidateFeatureList(true));
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    private String createText(List<Variable> variables, String fieldName) {
        ValueFieldCompositeObject vfco = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX));
        StringBuffer outText = new StringBuffer();
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fd != null) {
            outText.append(FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fd, vfco, this.myClassRepository));
        } else {
            outText.append(fieldName);
        }
        return outText.toString();
    }

    private String getIndents(int indentLevel, String indentMarker) {
        StringBuilder indentRoot = new StringBuilder();
        for (int i = 0; i < indentLevel + 1; ++i) {
            indentRoot.append(indentMarker);
        }
        return indentRoot.toString();
    }

    static List<FieldDefinition> getCandidateFieldList(ClassRepository repository) {
        return ClearValueProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), new MyFieldFilter());
    }

    static List<String> getCandidateFeatureList(boolean contextEmpty) {
        return contextEmpty ? Arrays.asList(DATE_TIME_INTEROPERABILITY_FEATURE) : Arrays.asList(HIDE_MAP_ENTRY_OPTION_FEATURE, FORCE_MAP_ENTRY_OPTION_FEATURE);
    }

    private Variable createFieldsDropDown(String selectedField, AvailableFieldListBuilder builder, String label) {
        FieldHierarchyNode field = this.myClassRepository.getFieldRepository().getFieldByName(selectedField);
        if (!builder.filtersAllow(field)) {
            String useField;
            List<FieldDefinition> allowedFields = builder.buildFieldDefinitionList();
            if (allowedFields.isEmpty()) {
                return new NotAllowedVariable(label, MSG_NO_FIELDS_EXISTS);
            }
            String string = useField = selectedField != null ? selectedField.trim() : "";
            if (useField.isEmpty() && allowedFields.size() > 0) {
                useField = allowedFields.get(0).getCanonicalName();
            }
            return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, null, allowedFields, useField);
        }
        return new LazyFieldDropDownVariable(label, builder, selectedField);
    }

    private Variable createClearKeyVariable(boolean isSelected) {
        return new BoolVariable(LBL_CLEARKEY, isSelected);
    }

    private Variable createNotAllowedVariable(String msg) {
        return new NotAllowedVariable(LBL_FIELD_INDEX, msg);
    }

    private List<Variable> createMapEntryOptionVariables(String fieldName, Element indexElement, boolean createDefaultIndexIfMissing) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        MapEntryOption option = this.investigateMapEntryOption(fieldName);
        switch (option) {
            case SHOW_MAP_ENTRY: {
                varList.add(this.createClearKeyVariable(indexElement != null));
                if (indexElement == null) break;
                this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, indexElement, varList, this.createIndexVariableFactory());
                break;
            }
            case FORCE_MAP_ENTRY: {
                Variable clearKeyVariable = this.createClearKeyVariable(true);
                varList.add(clearKeyVariable);
                if (indexElement != null) {
                    clearKeyVariable.setAllowEdit(false);
                    this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, indexElement, varList, this.createIndexVariableFactory());
                    break;
                }
                if (createDefaultIndexIfMissing) {
                    clearKeyVariable.setAllowEdit(false);
                    this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, null, varList, this.createIndexVariableFactory());
                    break;
                }
                clearKeyVariable.setValue(false);
                varList.add(this.createNotAllowedVariable(INDEX_MANDATORY_MSG));
                break;
            }
            case HIDE_MAP_ENTRY: {
                if (indexElement == null) break;
                varList.add(this.createClearKeyVariable(true));
                varList.add(this.createNotAllowedVariable(INDEX_NOT_ALLOWED_MSG));
                break;
            }
        }
        return varList;
    }

    private boolean fieldIsMap(String fieldName) {
        FieldDefinition fieldDef = this.myClassRepository.getFieldDefinitionByName(fieldName);
        return fieldDef != null && fieldDef.isMap();
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> variableList) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD_INDEX), this.myClassRepository, true));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        Element fieldElement = XMLUtil.getFirstElementNamed(LBL_FIELD, (Element)data);
        String fieldName = XMLUtil.getFirstTextContent(fieldElement);
        displayValuesMap.put(LBL_FIELD, fieldName);
        Element indexElement = XMLUtil.getFirstElementNamed(LBL_FIELD_INDEX, (Element)data);
        if (indexElement != null) {
            displayValuesMap.put(LBL_FIELD_INDEX, indexElement.getTextContent());
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = super.getDisplayValues(variables, prev);
        String destFieldIndex = VarListUtil.getValueStringForKey(variables, LBL_FIELD_INDEX);
        if (destFieldIndex != null) {
            displayValuesMap.put(LBL_FIELD_INDEX, destFieldIndex);
        }
        return displayValuesMap;
    }

    private MapEntryOption investigateMapEntryOption(String fieldName) {
        ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, fieldName).build();
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, ctx, this.myClassRepository, Arrays.asList(HIDE_MAP_ENTRY_OPTION_FEATURE, FORCE_MAP_ENTRY_OPTION_FEATURE));
        boolean fieldIsMap = this.fieldIsMap(fieldName);
        boolean forceMapEntryOption = enabledFeatures.contains(FORCE_MAP_ENTRY_OPTION_FEATURE);
        boolean hideMapEntryOption = enabledFeatures.contains(HIDE_MAP_ENTRY_OPTION_FEATURE);
        MapEntryOption option = MapEntryOption.NO_MAP;
        if (fieldIsMap) {
            option = forceMapEntryOption ? MapEntryOption.FORCE_MAP_ENTRY : (hideMapEntryOption ? MapEntryOption.HIDE_MAP_ENTRY : MapEntryOption.SHOW_MAP_ENTRY);
        }
        return option;
    }

    private IndexVariableFactory createIndexVariableFactory() {
        return IndexVariableFactory.buildFactory().withDateTimeInteroperability(this.mySupportDateTimeInteroperability).withFilterableFieldVariable(true).andRepository(this.myClassRepository);
    }

    private static enum MapEntryOption {
        NO_MAP,
        FORCE_MAP_ENTRY,
        HIDE_MAP_ENTRY,
        SHOW_MAP_ENTRY;

    }

    private static class MyFieldFilter
    implements FieldFilter {
        private MyFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return PARAM_TYPES.contains(field.getParameterType());
        }
    }
}

