/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.model;

import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.filter.ConfigurationParameterFilter;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ConfigurationParameterPipe
implements Transformer<Collection<ConfigurationParameter>, Collection<ConfigurationParameter>> {
    private List<ConfigurationParameterFilter> myFilters;

    private ConfigurationParameterPipe(List<ConfigurationParameterFilter> filters) {
        this.myFilters = filters;
    }

    public static ConfigurationParameterPipe create(ConfigurationParameterFilter serviceFilter, ConfigurationParameterFilter searchFilter) {
        if (serviceFilter == null || searchFilter == null) {
            throw new IllegalArgumentException("Filters cannot be null.");
        }
        return new ConfigurationParameterPipe(Arrays.asList(serviceFilter, searchFilter));
    }

    @Override
    public Collection<ConfigurationParameter> transform(Collection<ConfigurationParameter> input) {
        Collection<ConfigurationParameter> ret = input;
        for (ConfigurationParameterFilter pf : this.myFilters) {
            ret = CollectionUtils.filter(ret, pf);
        }
        return ret;
    }
}

