/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.time;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.logic.ImmutableCompoundBoolean;
import com.ericsson.ere.selectiontree.interfaces.MillisecondDurationSupport;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.UTime;
import ericsson.ere.xml.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class TimeOfDay
extends ImmutableCondition
implements TraceableV2,
MillisecondDurationSupport {
    private final long myStartTime;
    private final long myStopTime;
    private static final int ONE_DAY_IN_SECONDS = 86400;
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;

    private TimeOfDay(long theStartTime, long theStopTime, ParseContext ctx) {
        super(ctx);
        this.myStartTime = theStartTime;
        this.myStopTime = theStopTime + 1L;
    }

    public static ImmutableCondition create(ParseContext ctx, TariffStructureNode[] children) {
        long toTime;
        String from = null;
        String to = null;
        Node iterator = ctx.getXMLNode();
        NodeList nodeChildren = iterator.getChildNodes();
        Element node = XMLUtil.getNamedElement("From", nodeChildren);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: From");
        }
        from = XMLUtil.getFirstTextContent(node);
        node = XMLUtil.getNamedElement("To", nodeChildren);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: To");
        }
        to = XMLUtil.getFirstTextContent(node);
        if (from == null || "".equals(from)) {
            throw new IllegalArgumentException("Empty element: From");
        }
        if (to == null || "".equals(to)) {
            throw new IllegalArgumentException("Empty element: To");
        }
        long fromTime = UTime.timeToSec(from);
        if (fromTime > (toTime = UTime.timeToSec(to))) {
            TariffStructureNode[] conditions = new TariffStructureNode[]{new TimeOfDay(fromTime, 86399L, ctx), new TimeOfDay(0L, toTime, ctx)};
            return ImmutableCompoundBoolean.create(ImmutableCompoundBoolean.OperationType.OR, ctx, conditions);
        }
        return new TimeOfDay(fromTime, toTime, ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myStartTime ^ this.myStartTime >>> 32);
        result = 31 * result + (int)(this.myStopTime ^ this.myStopTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOfDay other = (TimeOfDay)obj;
        if (this.myStartTime != other.myStartTime) {
            return false;
        }
        return this.myStopTime == other.myStopTime;
    }

    @Override
    public boolean test(DataSet theData) {
        long currentTime = this.getCurrentTimeInSeconds(theData);
        return currentTime >= this.myStartTime && currentTime < this.myStopTime;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return this.calculateDurationInSeconds(this.myStopTime, this.getCurrentTimeInSeconds(theData));
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return this.calculateDurationInSeconds(this.myStartTime, this.getCurrentTimeInSeconds(theData));
    }

    @Override
    public long getConditionSatisfiedDurationInMilliseconds(DataSet theData) {
        return this.calculateDurationInMilliseconds(this.myStopTime * 1000L, this.getCurrentTimeInMilliseconds(theData));
    }

    @Override
    public long getConditionUnsatisfiedDurationInMilliseconds(DataSet theData) {
        return this.calculateDurationInMilliseconds(this.myStartTime * 1000L, this.getCurrentTimeInMilliseconds(theData));
    }

    private long calculateDurationInSeconds(long configuredTime, long currentTime) {
        long max = configuredTime - currentTime;
        return max < 0L ? max + 86400L : max;
    }

    private long calculateDurationInMilliseconds(long configuredTime, long currentTime) {
        long max = configuredTime - currentTime;
        return max < 0L ? max + 86400000L : max;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GregorianCalendar cal = new GregorianCalendar(2000, 1, 1, (int)this.myStartTime / 3600, (int)this.myStartTime / 60 % 60, (int)this.myStartTime % 60);
        String start = sdf.format(cal.getTime());
        int stopTime = (int)this.myStopTime - 1;
        cal = new GregorianCalendar(2000, 1, 1, stopTime / 3600, stopTime / 60 % 60, stopTime % 60);
        String stop = sdf.format(cal.getTime());
        String timeStr = sdfYear.format(dataSet.getCurrentTime().getTime());
        return this.createTraceDescriptionText("TimeOfDay", "<Current Time> ", timeStr, "is between", start + " and " + stop);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.remove("BuiltInDate");
        return set;
    }

    public long getCurrentTimeInSeconds(DataSet theData) {
        Calendar cal = theData.getCurrentTime();
        long currentTime = cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13);
        return currentTime;
    }

    private long getCurrentTimeInMilliseconds(DataSet theData) {
        long allButMillis = this.getCurrentTimeInSeconds(theData) * 1000L;
        Calendar cal = theData.getCurrentTime();
        return allButMillis + (long)cal.get(14);
    }
}

