/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.time;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.DateUtil;
import ericsson.ere.util.UTime;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class TimeOfCall
extends ImmutableCondition
implements TraceableV2 {
    private final long myStartTime;
    private final long myStopTime;
    private static final Object DURATION = new Object();

    public static TimeOfCall create(ParseContext ctx, TariffStructureNode[] children) {
        return new TimeOfCall(ctx);
    }

    private TimeOfCall(ParseContext ctx) {
        super(ctx);
        long toTime;
        String from = null;
        String to = null;
        Node config = ctx.getXMLNode();
        NodeList children = config.getChildNodes();
        Element node = XMLUtil.getNamedElement("From", children);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: From");
        }
        from = XMLUtil.getFirstTextContent(node);
        node = XMLUtil.getNamedElement("To", children);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: To");
        }
        to = XMLUtil.getFirstTextContent(node);
        if (from == null || "".equals(from)) {
            throw new IllegalArgumentException("Empty element: From");
        }
        if (to == null || "".equals(to)) {
            throw new IllegalArgumentException("Empty element: To");
        }
        long fromTime = UTime.timeToSec(from);
        if (fromTime > (toTime = UTime.timeToSec(to))) {
            throw new IllegalArgumentException("From Time (" + from + ") is greater than To time (" + to + ").");
        }
        this.myStartTime = fromTime;
        this.myStopTime = toTime + 1L;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myStartTime ^ this.myStartTime >>> 32);
        result = 31 * result + (int)(this.myStopTime ^ this.myStopTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOfCall other = (TimeOfCall)obj;
        if (this.myStartTime != other.myStartTime) {
            return false;
        }
        return this.myStopTime == other.myStopTime;
    }

    @Override
    public boolean test(DataSet theData) {
        boolean result = false;
        TreeTask task = theData.getTreeTask();
        if (task instanceof TimeBasedTask) {
            TimeBasedTask tTask = (TimeBasedTask)task;
            long duration = tTask.getAllocatedDuration();
            result = duration >= this.myStartTime && duration < this.myStopTime;
        }
        return result;
    }

    @Deprecated
    public long getConditionSatisfiedDuration(TimeBasedTask tTask) {
        long max = Long.MAX_VALUE;
        if (tTask.getAllocatedDuration() < this.myStopTime) {
            max = this.myStopTime - tTask.getAllocatedDuration();
        }
        return max;
    }

    @Deprecated
    public long getConditionUnsatisfiedDuration(TimeBasedTask tTask) {
        long max = Long.MAX_VALUE;
        if (tTask.getAllocatedDuration() < this.myStartTime) {
            max = this.myStartTime - tTask.getAllocatedDuration();
        }
        return max;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        Long duration = (Long)tp.getInfo(DURATION);
        String startTimeFormatted = DateUtil.formatSeconds(this.myStartTime);
        String stopTimeFormatted = DateUtil.formatSeconds(this.myStopTime - 1L);
        String durationString = duration != null ? DateUtil.formatSeconds(duration) : null;
        String condConfigValue = startTimeFormatted + " and " + stopTimeFormatted;
        return this.createTraceDescriptionText("TimeOfCall", "<Time in call> ", durationString, "is between", condConfigValue);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        TreeTask task = tp.getPreDataSet().getTreeTask();
        if (task instanceof TimeBasedTask) {
            tp.addInfo(DURATION, ((TimeBasedTask)task).getAllocatedDuration());
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

