/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.structure;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.ValueContainer;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionCondition;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionParseContext;
import com.ericsson.ere.selectiontree.conditions.structure.CollectionContainsConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

@Immutable
public final class CollectionContainsCondition
extends ImmutableCondition
implements FieldMappable,
TraceableV2 {
    private final FieldStructure myField;
    private final Map<FieldDefinition, List<ContextCondition>> myFieldToConditionsMap = new LinkedHashMap<FieldDefinition, List<ContextCondition>>();

    private CollectionContainsCondition(ParseContext ctx) {
        super(ctx, CollectionContainsCondition.getFieldNameFromFieldSelectionParseContext(ctx));
        ClassRepository repository = ctx.getClassRepository();
        FieldHierarchyNode configuredField = repository.getFieldRepository().getFieldByName(this.key);
        this.check(configuredField != null && !configuredField.isLeaf(), "Faulty condition configuration - mapped field must be a hierachical field.");
        this.myField = (FieldStructure)configuredField;
        CollectionContainsConditionConfiguration config = new CollectionContainsConditionConfiguration(ctx);
        List<Element> subConditionConfigs = config.getSubConditionConfigs();
        this.check(!subConditionConfigs.isEmpty(), "Faulty condition configuration - Missing sub conditions.");
        for (Element conditionXml : subConditionConfigs) {
            ContextCondition subCondition = this.createContextSubCondition(repository, conditionXml);
            String subConditionFieldName = XMLUtil.getFirstElementNamed("Field", conditionXml).getAttribute("field");
            FieldDefinition subConditionField = repository.getFieldDefinitionByName(subConditionFieldName);
            this.check(subConditionField.getParent() == this.myField, "Faulty condition configuration - field connected to sub condition is not a child of the configured field.");
            this.addSubCondition(subConditionField, subCondition);
        }
    }

    public static TariffStructureNode create(ParseContext context, TariffStructureNode[] notused) {
        return new CollectionContainsCondition(context);
    }

    @Override
    public boolean test(DataSet theData) {
        boolean retValue = false;
        try {
            Object data = theData.getAccessor().getValue(this.myField, null, null);
            retValue = this.doTest(data, theData);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return retValue;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        ArrayList<String> traces = new ArrayList<String>();
        for (Map.Entry<FieldDefinition, List<ContextCondition>> fieldConditionEntry : this.myFieldToConditionsMap.entrySet()) {
            FieldDefinition subField = fieldConditionEntry.getKey();
            List<ContextCondition> conditions = fieldConditionEntry.getValue();
            FixedValueTraceContext traceCtx = new FixedValueTraceContext(subField.getCanonicalName(), "...", tp);
            for (ContextCondition condition : conditions) {
                traces.add(condition.describeTrace(traceCtx));
            }
        }
        StringBuilder sb = new StringBuilder("CollectionContainsCondition: ");
        sb.append(this.getFieldStructureDescription());
        sb.append(", tested the following sub-conditions:\n");
        for (String trace : traces) {
            sb.append("   ").append(trace).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        for (ContextCondition cond : this.getAllConditions()) {
            if (!(cond instanceof TraceableV2)) continue;
            ((TraceableV2)((Object)cond)).setPreTracePointInfo(tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        for (ContextCondition cond : this.getAllConditions()) {
            cond.setTracePointInfo(tp);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionContainsCondition other = (CollectionContainsCondition)obj;
        if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
            return false;
        }
        return !(this.myFieldToConditionsMap == null ? other.myFieldToConditionsMap != null : !this.myFieldToConditionsMap.equals(other.myFieldToConditionsMap));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        result = 31 * result + (this.myFieldToConditionsMap == null ? 0 : this.myFieldToConditionsMap.hashCode());
        return result;
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        for (FieldDefinition subField : this.myFieldToConditionsMap.keySet()) {
            set.add(subField.getCanonicalName());
        }
        return set;
    }

    private void check(boolean isValid, String exceptionMessage) throws PluginCreationException {
        if (!isValid) {
            throw new PluginCreationException(exceptionMessage);
        }
    }

    private ContextCondition createContextSubCondition(ClassRepository repository, Element conditionXml) {
        TariffStructureNode subCondition = FieldSelectionCondition.create(new ParseContextAdapter(repository, conditionXml, null), null);
        String subConditionString = DomWriter.elementToString(conditionXml);
        this.check(subCondition.getClass().isAnnotationPresent(Immutable.class), "Sub-condition is not immutable: " + subConditionString);
        this.check(subCondition instanceof ContextCondition, "Sub-condition is not a Context Condition: " + subConditionString);
        return (ContextCondition)((Object)subCondition);
    }

    private void addSubCondition(FieldDefinition subConditionField, ContextCondition subCondition) {
        List<ContextCondition> conditionList = this.myFieldToConditionsMap.get(subConditionField);
        if (conditionList == null) {
            conditionList = new ArrayList<ContextCondition>();
            this.myFieldToConditionsMap.put(subConditionField, conditionList);
        }
        conditionList.add(subCondition);
    }

    private boolean doTest(Object data, DataSet dataSet) {
        boolean retValue = false;
        switch (this.myField.getComplexType()) {
            case NONE: {
                retValue = this.testStructure((ValueContainer)data, dataSet);
                break;
            }
            case ARRAY: {
                retValue = this.testArray((Map)data, dataSet);
                break;
            }
            case MAP: {
                retValue = this.testMap((Map)data, dataSet);
                break;
            }
            case SET: {
                retValue = this.testSet((Set)data, dataSet);
            }
        }
        return retValue;
    }

    private boolean testStructure(ValueContainer data, DataSet dataSet) {
        boolean retValue = true;
        for (Map.Entry<FieldDefinition, List<ContextCondition>> fieldConditionEntry : this.myFieldToConditionsMap.entrySet()) {
            FieldDefinition subField = fieldConditionEntry.getKey();
            ValueContainerExecutionContext exeCtx = new ValueContainerExecutionContext(data, subField, dataSet);
            retValue = this.testSubConditions(fieldConditionEntry.getValue(), exeCtx);
            if (retValue) continue;
            break;
        }
        return retValue;
    }

    private boolean testArray(Map<Key, ValueContainer> arrayData, DataSet dataSet) {
        ValueContainer data;
        boolean retValue = false;
        Iterator<ValueContainer> iterator = arrayData.values().iterator();
        while (iterator.hasNext() && !(retValue = this.testStructure(data = iterator.next(), dataSet))) {
        }
        return retValue;
    }

    private boolean testSet(Set<ValueContainer> setData, DataSet dataSet) {
        ValueContainer data;
        boolean retValue = false;
        Iterator<ValueContainer> iterator = setData.iterator();
        while (iterator.hasNext() && !(retValue = this.testStructure(data = iterator.next(), dataSet))) {
        }
        return retValue;
    }

    private boolean testMap(Map<Key, ValueContainer> mapData, DataSet dataSet) {
        boolean retValue = false;
        for (Map.Entry<Key, ValueContainer> mapEntry : mapData.entrySet()) {
            for (Map.Entry<FieldDefinition, List<ContextCondition>> fieldConditionEntry : this.myFieldToConditionsMap.entrySet()) {
                FieldDefinition subField = fieldConditionEntry.getKey();
                ExecutionContext exeCtx = this.createExecutionContextForMapStructure(subField, mapEntry.getKey(), mapEntry.getValue(), dataSet);
                retValue = this.testSubConditions(fieldConditionEntry.getValue(), exeCtx);
                if (retValue) continue;
                break;
            }
            if (!retValue) continue;
            break;
        }
        return retValue;
    }

    private ExecutionContext createExecutionContextForMapStructure(FieldDefinition subField, Key key, ValueContainer vc, DataSet dataSet) {
        ExecutionContext retExeCtx;
        if (subField.isKey()) {
            Object data = key.getKey();
            if (data instanceof ComplexKey) {
                int fieldKeyIndex = FieldDefinitionHelper.getFieldKeyIndex(subField);
                data = ((ComplexKey)data).getKeyObjectForIndex(fieldKeyIndex);
            }
            retExeCtx = new FixedValueExecutionContext(data, dataSet);
        } else {
            retExeCtx = new ValueContainerExecutionContext(vc, subField, dataSet);
        }
        return retExeCtx;
    }

    private boolean testSubConditions(List<ContextCondition> conditions, ExecutionContext exeCtx) {
        ContextCondition subCondition;
        boolean retValue = true;
        Iterator<ContextCondition> iterator = conditions.iterator();
        while (iterator.hasNext() && (retValue = (subCondition = iterator.next()).test(exeCtx))) {
        }
        return retValue;
    }

    private String getFieldStructureDescription() {
        return this.myField.getComplexType() == FieldHierarchyNode.ComplexType.NONE ? this.myField.getFieldName() : this.myField.toString();
    }

    private List<ContextCondition> getAllConditions() {
        ArrayList<ContextCondition> conditions = new ArrayList<ContextCondition>();
        for (Map.Entry<FieldDefinition, List<ContextCondition>> fieldConditionEntry : this.myFieldToConditionsMap.entrySet()) {
            for (ContextCondition condition : fieldConditionEntry.getValue()) {
                conditions.add(condition);
            }
        }
        return conditions;
    }

    private static String getFieldNameFromFieldSelectionParseContext(ParseContext ctx) {
        String fieldName = null;
        if (ctx instanceof FieldSelectionParseContext) {
            fieldName = ((FieldSelectionParseContext)ctx).getFieldName();
        }
        return fieldName;
    }

    private static class FixedValueTraceContext
    extends TraceContext {
        private final String myFieldName;
        private final String myTraceValue;
        private final TracePoint myTracePoint;

        private FixedValueTraceContext(String fieldName, String traceValue, TracePoint tp) {
            this.myFieldName = fieldName;
            this.myTraceValue = traceValue;
            this.myTracePoint = tp;
        }

        @Override
        public String getFieldDescription() {
            return this.myFieldName;
        }

        @Override
        public String getTraceValue() {
            return this.myTraceValue;
        }

        @Override
        public TracePoint getTracePoint() {
            return this.myTracePoint;
        }
    }

    private static class ValueContainerExecutionContext
    extends ExecutionContext {
        private final ValueContainer myData;
        private final FieldHierarchyNode myField;
        private final DataSet myDataSet;

        private ValueContainerExecutionContext(ValueContainer data, FieldHierarchyNode field, DataSet dataSet) {
            this.myData = data;
            this.myField = field;
            this.myDataSet = dataSet;
        }

        @Override
        public Object getValue(DataType dataType) {
            Object data = null;
            try {
                data = this.myData.getData(this.myField, dataType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }

        @Override
        public DataSet getDataSet() {
            return this.myDataSet;
        }
    }

    private static class FixedValueExecutionContext
    extends ExecutionContext {
        private final Object myValue;
        private final DataSet myDataSet;

        private FixedValueExecutionContext(Object value, DataSet dataSet) {
            this.myValue = value;
            this.myDataSet = dataSet;
        }

        @Override
        public Object getValue(DataType dataType) {
            return DefaultDataSet.convertValue(this.myValue, dataType);
        }

        @Override
        public DataSet getDataSet() {
            return this.myDataSet;
        }
    }
}

