/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class SubstringAtConditionProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionInterface {
    public static final String LABEL_SUBSTRING = "Substring";
    public static final String LABEL_INDEX = "Index (0-based)";
    public static final String LABEL_MATCH_CASE = "Match case";
    private String myFieldDefinitionName;

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int index = VarListUtil.getIntValueForName(variables, LABEL_INDEX);
        String substring = VarListUtil.getValueStringForName(variables, LABEL_SUBSTRING);
        boolean matchCase = VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE);
        StringBuffer buf = new StringBuffer();
        buf.append(this.indentation(indentLevel, indentMarker));
        out.println(buf + "<" + "Index" + ">" + index + "</" + "Index" + ">");
        out.println(buf + "<" + LABEL_SUBSTRING + ">" + substring + "</" + LABEL_SUBSTRING + ">");
        out.println(buf + "<" + "MatchCase" + ">" + matchCase + "</" + "MatchCase" + ">");
    }

    @Override
    public List<Variable> getVariables() {
        return this.createVariables("0", "", true);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        Element indexNode = XMLUtil.getNamedElement("Index", children);
        String index = XMLUtil.getFirstTextContent(indexNode);
        Element substringNode = XMLUtil.getNamedElement(LABEL_SUBSTRING, children);
        String substring = XMLUtil.getFirstTextContent(substringNode);
        Element matchCaseNode = XMLUtil.getNamedElement("MatchCase", children);
        String matchCaseString = XMLUtil.getFirstTextContent(matchCaseNode);
        boolean matchCase = Boolean.parseBoolean(matchCaseString);
        return this.createVariables(index, substring, matchCase);
    }

    private List<Variable> createVariables(String index, String subString, boolean matchCase) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new IntegerVariable(LABEL_INDEX, index, 0, Integer.MAX_VALUE));
        l.add(new StringVariable(LABEL_SUBSTRING, subString));
        l.add(new BoolVariable(LABEL_MATCH_CASE, matchCase));
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String index = VarListUtil.getValueStringForName(variables, LABEL_INDEX);
        String substring = VarListUtil.getValueStringForName(variables, LABEL_SUBSTRING);
        return name + " index = " + index + ", substring = '" + substring + "'";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String index = VarListUtil.getValueStringForName(variables, LABEL_INDEX);
        String substring = VarListUtil.getValueStringForName(variables, LABEL_SUBSTRING);
        String matchCase = VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE) != false ? ", case sensitive" : ", case insensitive";
        String info = "<b>" + name + "</b> (substring at index = " + index + " equals '" + substring + "'" + matchCase + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsConfig) throws Exception {
        Element indexNode = XMLUtil.getFirstElementNamed("Index", (Element)variableValueIterator);
        Element substringNode = XMLUtil.getFirstElementNamed(LABEL_SUBSTRING, (Element)variableValueIterator);
        String testString = null;
        if (indexNode != null && substringNode != null) {
            String indexString = indexNode.getTextContent();
            int index = Integer.parseInt(indexString);
            String substring = substringNode.getTextContent();
            testString = this.getStringWithPrefix(index, substring);
        }
        if (testString == null) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDefinitionName, testString);
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinitionName = fieldDefinition.getFieldName();
    }

    private String getStringWithPrefix(int prefixLength, String substring) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            sb.append("a");
        }
        return sb + substring;
    }
}

