/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.string.CharacterTree;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

@Immutable
public final class OctetStringList
extends ImmutableFieldMappableCondition
implements TraceableV2,
ContextCondition {
    static final String TAG_MODE = "Mode";
    private final CharacterTree myStrings;

    private OctetStringList(ParseContext ctx, CharacterTree chartree) {
        super(ctx);
        this.myStrings = chartree;
    }

    public static OctetStringList create(ParseContext ctx, TariffStructureNode[] notUsed) {
        String theStrings = "";
        String mode = "Ascii";
        Node nodeConfig = ctx.getXMLNode();
        if (nodeConfig.hasChildNodes()) {
            for (Node el : XMLUtil.getElementChildren(nodeConfig)) {
                if (el.getNodeName().equals("String")) {
                    theStrings = XMLUtil.getFirstTextContent(el);
                    continue;
                }
                if (!el.getNodeName().equals(TAG_MODE)) continue;
                mode = XMLUtil.getFirstTextContent(el);
            }
        }
        CharacterTree chartree = OctetStringList.extractCharacterTreeFromStrings(theStrings, mode);
        return new OctetStringList(ctx, chartree);
    }

    private static CharacterTree extractCharacterTreeFromStrings(String strings, String mode) {
        CharacterTree chartree;
        if ("Hex".equals(mode)) {
            StringTokenizer next = new StringTokenizer(strings, ",\t\n\r\u0000", true);
            String newStrings = "";
            while (next.hasMoreTokens()) {
                String token = next.nextToken();
                if (",".equals(token) || "\t".equals(token) || "\n".equals(token) || "\r".equals(token) || "\u0000".equals(token)) {
                    newStrings = newStrings + token;
                    continue;
                }
                OctetString oStr = OctetString.valueOf(token);
                newStrings = newStrings + oStr.toExtendedAscii();
            }
            chartree = new CharacterTree(newStrings, true);
        } else {
            chartree = new CharacterTree(strings);
        }
        return chartree;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myStrings == null ? 0 : this.myStrings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringList other = (OctetStringList)obj;
        return !(this.myStrings == null ? other.myStrings != null : !this.myStrings.equals(other.myStrings));
    }

    @Override
    public boolean test(DataSet theData) {
        OctetString value = null;
        try {
            value = (OctetString)this.extractFieldValueFromDataSet(theData, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        OctetString value = (OctetString)exeCtx.getValue(DataType.OCTETSTRING);
        return this.doTest(value);
    }

    private boolean doTest(OctetString value) {
        boolean retVal = false;
        if (value != null) {
            String asciiValue = OctetString.isDisplayableUSAscii(value) ? value.toAscii() : value.toExtendedAscii();
            retVal = this.myStrings.checkString(asciiValue);
        }
        return retVal;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        OctetString fieldValue = null;
        try {
            fieldValue = (OctetString)this.extractFieldValueFromDataSet(dataSet, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(this.describeFieldName(dataSet), fieldValue, (DataSet)dataSet);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(traceCtx.getTracePoint());
        String fieldValue = "...".equals(traceCtx.getTraceValue()) ? traceCtx.getTraceValue() : this.describeOctetString(OctetString.valueOf(traceCtx.getTraceValue()), dataSet);
        return this.doDescribeTrace(traceCtx.getFieldDescription(), fieldValue, (DataSet)dataSet);
    }

    private String doDescribeTrace(String selectedFieldName, OctetString fieldValue, DataSet dataSet) {
        String testedFieldValue = this.describeOctetString(fieldValue, dataSet);
        return this.doDescribeTrace(selectedFieldName, testedFieldValue, dataSet);
    }

    private String doDescribeTrace(String selectedFieldName, String fieldValue, DataSet dataSet) {
        return this.createTraceDescriptionText("OctetStringList", selectedFieldName, fieldValue, "is found", "in list");
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.OBJECT);
    }
}

