/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class BcdStringConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static String LABEL_COMPARATION = "Comparison";
    private static String LABEL_TEXT = "Text";
    private final String[] myComparationChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};
    private FieldDefinition myFieldDef;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        this.addInputVariables(l, "0", null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value) {
        Variable inputVariable = this.createInputVariable(LABEL_TEXT, null, value, DataType.BCDSTRING);
        if (this.supportsInequalityOperators(inputVariable)) {
            l.add(new DropDownVariable(LABEL_COMPARATION, (Object)selection, 1, this.myComparationChoices));
        }
        l.add(inputVariable);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        String text = null;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("Comparation") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                comp = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("Text") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            text = value.item(bb).getNodeValue();
        }
        this.addInputVariables(l, comp, text);
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        if (name == null) {
            name = this.getName();
        }
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = this.getDisplayableValueForComparison(comp);
        String text = this.getTextForDisplayFromVariables(variables);
        return name + " " + comp + " " + text;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT);
        out.println("<Text>" + text.toUpperCase() + "</" + "Text" + ">");
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        if (comp == null) {
            comp = "3";
        }
        out.println("<Comparation>" + comp + "</" + "Comparation" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String compToken = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        String comp = this.getDisplayableValueForComparison(compToken);
        String text = this.getTextForDisplayFromVariables(variables);
        String info = "<b>" + this.getName() + "</b> (" + comp + " " + text + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    private String getTextForDisplayFromVariables(List<Variable> variables) {
        Variable variable = VarListUtil.getVariableForName(variables, LABEL_TEXT);
        String displayString = variable.toString();
        if (this.supportsInequalityOperators(variable)) {
            displayString = "\"" + displayString + "\"";
        }
        return displayString;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element textElement = XMLUtil.getFirstElementNamed("Text", (Element)variableValueIterator);
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        if (textElement != null) {
            String textString = XMLUtil.getFirstTextContent(textElement);
            if (textString.length() == 0) {
                fieldInformation.put(this.myFieldDef.getFieldName(), new BcdString(""));
            } else {
                fieldInformation.put(this.myFieldDef.getFieldName(), new BcdString(textString));
            }
        }
        if (fieldInformation.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeComparationFromVariables(displayValuesMap, variables);
        String value = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        displayValuesMap.put(LABEL_TEXT, value);
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeComparationFromNode(displayValuesMap, data);
        String value = this.getValueString(data);
        displayValuesMap.put(LABEL_TEXT, value);
        return displayValuesMap;
    }

    private String getValueString(Node data) {
        String text = XMLUtil.getNamedElement("Text", data.getChildNodes()).getTextContent();
        return this.makeDisplayString(text, DataType.BCDSTRING);
    }

    private void storeComparationFromNode(Map<String, Object> store, Node data) {
        Element compElement = XMLUtil.getNamedElement("Comparation", data.getChildNodes());
        String comparation = compElement == null ? null : compElement.getTextContent();
        store.put(LABEL_COMPARATION, this.getDisplayableValueForComparison(comparation));
    }

    private void storeComparationFromVariables(Map<String, Object> store, List<Variable> variables) {
        String comparison = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        store.put(LABEL_COMPARATION, this.getDisplayableValueForComparison(comparison));
    }

    private String getDisplayableValueForComparison(String compToken) {
        String comparator = compToken == null ? this.myComparationChoices[3].toLowerCase() : ("-1".equals(compToken) ? "Invalid" : this.myComparationChoices[Integer.valueOf(compToken)].toLowerCase());
        return comparator;
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        return false;
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
    }
}

