/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class LongCondition
extends AbstractImmutableNumberCondition<Long>
implements ContextCondition {
    private LongCondition(ParseContext context) {
        super(context, "Long", DataType.LONG);
    }

    public static LongCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new LongCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.LONG);
    }

    protected static Element getElementToUse(Node config) {
        Element elementToUse = XMLUtil.getNamedElement("IntValue", config.getChildNodes());
        if (elementToUse == null) {
            elementToUse = XMLUtil.getNamedElement("LongValue", config.getChildNodes());
        }
        return elementToUse;
    }

    @Override
    protected String getValueString(Node iterator) {
        Element elementToUse = LongCondition.getElementToUse(iterator);
        String value = XMLUtil.getFirstTextContent(elementToUse);
        return value;
    }

    @Override
    protected Long parseValue(String value) {
        return TreeParseUtil.parseLong(value);
    }

    @Override
    protected String getValueAsString(Long value) {
        return Long.toString(value);
    }

    @Override
    protected boolean evaluate(Long value, Long dataSetValue) throws Exception {
        return this.compareSignedNumbers(value, dataSetValue);
    }

    @Override
    protected Long getValueFromDataSet(DataSet ds) {
        return this.fetchNumberFromDataSet(ds).longValue();
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Long)exeCtx.getValue(DataType.LONG));
    }
}

